/* $Id: gpw.c,v 1.5 2000/09/20 14:30:22 mattiasa Exp $ */

#include <stdio.h>
#include <readline/readline.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <pw.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <z/itemize.h>

#define STUDIESERVER "open.admin.kth.se"
#define STUDIEPORT 1234

char * progname;

int main (int argc, char ** argv) {

    int chpass_fd;
    char * username = NULL;
    char * old;
    char * pnr;
    char * yesno;
    char * passwd;
    char ** items;
    char ** gechos;
    char * fullname;

    int studieanm = 0;

    progname = argv[0];
    chpass_fd = pw_args (&argc, &argv);

    if (argc > 1) {
	username = argv[1];
    }

    if (username == NULL) {
	username = readline("Skriv in anvndarnamnet vars lsenord skall ndras: ");
    }

    old = pw_getpwnam (chpass_fd, username);

    if (old == NULL) {
	printf("Username %s doesn't seem to exist. Aborting.\n", username);
	pw_abort();
    }

    items = itemize(old, ":");

    if(items != NULL) {
	 gechos = itemize(items[4], ",");
	 if(gechos != NULL) {
	      fullname = gechos[0];
	 } else {
	      fullname = NULL;
	 }
    } else {
	 fullname = NULL;
    }

    pnr = pnr_getbyname(chpass_fd, username);

    if (pnr == NULL) {
      pnr = readline("Kunde inte finna anvndarens pnr. Skriv in det (utan -) :");
      pnr_create(chpass_fd, pnr, username);
    }
    
    if(!(studieanm = checkstudie(pnr))) {
	printf("Anvndaren har inte gjort studeanmlan.\n");
	yesno = readline("Vill du nd generera lsenord [JA/nej]: ");

	if(!checkyesno(yesno))
	    exit(0);

	free(yesno);
    }

    printf("\n");
    printf("-----------------------------\n");
    printf("Namn\t\t: %s\n", fullname);
    printf("Anvndarnamn\t: %s\n", username);
    printf("Personnummer\t: %s\n", pnr);
    printf("Studieanmlan\t: %s\n", studieanm ? "Ja" : "Nej");
    printf("-----------------------------\n");

    yesno = readline("Vill du generera ett nytt lsenord [JA/nej]: ");

    if(checkyesno(yesno)) {

	pw_kadm_usr_init (30);

	passwd = pw_mkpasswd(username);

	pw_kadm_change_password (username, passwd);

	if (pw_errno != PW_EOK) {
	    bzero(passwd, strlen(passwd));
	    pw_abort();
	}

	printf("Det nya lsenordet r: %s\n", passwd);
	free(yesno);
	yesno = readline("Vill du ha en utskrift [JA/nej]: ");
	if(checkyesno(yesno)) {
            FILE *pip;
            int i ;
	    char motd[] = "OBS --> Det r skillnad p stora och sm bokstver i lsenordet. <---\n" 
		"Du ndrar lsen med \"passwd\" i UNIX.\n"
		"Byt INTE tillbaka till ditt f|regende lsenord.\n"
		"Vlj ett lsenord som bestr utav minst tta tecken.\n"
		"Anvnd begynnelsebokstverna i ngon nonsensmening\n"
		"Anvnd siffror, skiljetecken och blandat STORA oCh sm bokstver\n";

            pip = popen("lpr -Pdumle", "w");
            if (pip != NULL) {

                fprintf(pip, "%s\n\n", motd);   /* 8 rows */

                fprintf(pip, "Password: %s\r\n          ( ", passwd);

		for (i=0; i < strlen(passwd) ; i++) {
		    fprintf(pip, "%s ", pw_convchartoword(passwd[i]));
		}

		fprintf(pip,")\r\n");

                for (i = 0 ; i < 40 ; i++)
                    fprintf(pip, "\r\n");
                
                fclose(pip);
	    }
	}

    }

    return 0;
}

int checkyesno(char * yesno) {
    return (yesno[0] == 'j' || yesno[0] == 'J' ||
	    yesno[0] == 'y' || yesno[0] == 'Y' || yesno[0] == '\0');
}

int checkstudie (char * pnr) {

  struct hostent *host;
  struct sockaddr_in sin;
  int s;
  char result;

  host = gethostbyname(STUDIESERVER);

  sin.sin_port = htons(STUDIEPORT);
  memcpy(&sin.sin_addr, host->h_addr, sizeof sin.sin_addr);
  sin.sin_family = host->h_addrtype;

  if(( s = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0) {
    perror("Couldn't create socket\n");
    return 0;
  }

  if(connect(s, (struct sockaddr *)&sin, sizeof(struct sockaddr_in)) < 0) {
    perror("Couldn't connect");
    return 0;
  }


#if 0
    struct addrinfo hints, *res, *res0;
    int error;
    int s;
    const char *cause = NULL;

    memset(&hints, 0, sizeof(hints));
    hints.ai_family = PF_UNSPEC;
    hints.ai_socktype = SOCK_STREAM;

    printf("Looking for address info for %s\n", STUDIESERVER);

    error = getaddrinfo(STUDIESERVER, STUDIEPORT, &hints, &res0);
    if (error) {
	errx(0, "%s", gai_strerror(error));
	return 0;
    }

    printf("Found it, trying to connect.\n");

    s = -1;

    for (res = res0; res; res = res->ai_next) {
	s = socket(res->ai_family, res->ai_socktype,
		   res->ai_protocol);
	if (s < 0) {
	    cause = "socket";
	    continue;
	}

	if (connect(s, res->ai_addr, res->ai_addrlen) < 0) {
	    cause = "connect";
	    close(s);
	    s = -1;
	    continue;
	}

	break;  /* okay we got one */
    }
    if (s < 0) {
      printf("connect: %s\n", cause);
      return 0;
    }
    freeaddrinfo(res0);

#endif

    write(s, pnr, strlen(pnr));
    write(s, "\n", 1);

    read(s, &result, 1);
    return (result == '1');

}
