
#include <stdio.h>
#include <ctype.h>

#include <z/bool.h>
#include <z/error.h>
#include <z/str.h>

#include <pw.h>

char *progname = "pwbatch";


int
main (argc, argv)
    int argc;
    char *argv[];
{
    int d;
    FILE *fp;
    char pwline[PW_BUFLEN];

	    
    if (argc != 2)
    {
	fprintf (stderr, "usage: %s infile\n", progname);
	exit (1);
    }

    fp = fopen (argv[1], "r");
    if (fp == NULL)
	my_sysabort("Can't open infile: %s", argv[1]);

    d = pw_args (&argc, &argv);

    while (fgets (pwline, PW_BUFLEN, fp) != NULL)
    {
	stripline (pwline);
	pw_create (d, pwline);
	if (pw_errno != PW_EOK)
	    pw_abort ();
    }

    if (ferror (fp))
	my_sysabort("Error while reading infile: %s", argv[1]);

    fclose (fp);

    pw_close (d);

    exit (0);
}

