
/* convert.c
 *
 */

#include <stdio.h>
#include <z/bool.h>
#include <z/itemize.h>
#include <z/cleanup.h>
#include <stdlib.h>
#include <string.h>
#include "pw.h"

char *
pw_data_to_string (d)
    pw_data *d;
{
    int i;
    int len;
    char *s;
    char *src;
    char *dst;

    len = 0;
    for (i = 0; i < PW_GECOS; i++)
 	len += strlen (d->pwv[i]) + 1;
    for (i = 0; i < GC_NFIELDS; i++)
	len += strlen (d->gcv[i]) + 1;
    for (i = PW_GECOS + 1; i < PW_NFIELDS; i++)
	len += strlen (d->pwv[i]) + 1;

    s = malloc (len);
    if (s == NULL)
	return NULL;

    dst = s;

    if (d->gcv == NULL)
    {
	for (i = 0; i < PW_NFIELDS; i++)
	{
	    src = d->pwv[i];
	    while ((*dst++ = *src++))
		;
	    *(dst - 1) = ':';
	}
    }
    else
    {
	for (i = 0; i < PW_GECOS; i++)
	{
	    src = d->pwv[i];
	    while ((*dst++ = *src++))
		;
	    *(dst - 1) = ':';
	}
	for (i = 0; i < GC_NFIELDS; i++)
	{
	    src = d->gcv[i];
	    while ((*dst++ = *src++))
		;
	    *(dst - 1) = ',';
	} 
	*(dst - 1) = ':';
	for (i = PW_GECOS + 1; i < PW_NFIELDS; i++)
	{
	    src = d->pwv[i];
	    while ((*dst++ = *src++))
		;
	    *(dst - 1) = ':';
	}
    }
    *--dst = '\0';
    
    return s;
}
    

pw_data *
pw_string_to_data (s)
    char *s;
{
    pw_data *d;

    cleanup_mark ();

    d = (pw_data *) cleanup_malloc (sizeof (pw_data));

    d->pwv = itemize (s, ":");
    if (d->pwv == NULL)
	FAIL (NULL);
    cleanup_push (itemfree, d->pwv);

    if (itemcount (d->pwv) < PW_GECOS + 1)
    {
	d->gcv = NULL;
	RETURN (d);
    }

    d->gcv = itemize (d->pwv[PW_GECOS], ",");
    if (d->gcv == NULL)
	FAIL (NULL);
    cleanup_push (itemfree, d->gcv);

    RETURN (d);
}
    

void
pw_free_data (d)
    pw_data *d;
{
    if (d->gcv)
	itemfree (d->gcv);
    itemfree (d->pwv);
    free (d);
}

char *
info_data_to_string (d)
    info_data *d;
{
    int i;
    int len;
    char *s;
    char *src;
    char *dst;

    len = 0;
    len += strlen (d->info[0]) + 1;
    for (i = 0; d->uname[i] != NULL; i++) {
	len += strlen (d->uname[i]) + 1;
    }
    len += strlen (d->info[2]) + 1;
    

    s = malloc (len * sizeof(char));
    if (s == NULL)
	return NULL;

    dst = s;

    src = d->info[0];
    while ((*dst++ = *src++))
      ;
    *(dst -1 ) = ':';
    for (i=0; d->uname[i] != NULL; i++) {
      src = d->uname[i];
      while ((*dst++ = *src++))
	;
      *(dst -1) = ',';
    }
    *(dst -1) = ':';

    src = d->info[2];
    while ((*dst++ = *src++))
      ;
    
    *--dst = '\0';
    
    return s;
}
    

info_data *
info_string_to_data (s)
    char *s;
{
  /* String of format:
     pnr:unames:comment 
     And a empty info is
     pnr: : '\0';
     */

    info_data *d;

    d = (info_data *) malloc (sizeof (info_data));
    if (d == NULL)
      return NULL;

    if((d->info = itemize(s,":")) == NULL) {
      free(d);
      return NULL;
    }

    if ((d->uname = itemize (d->info[1], ",")) == NULL) {
      itemfree(d->info);
      free(d);
      return NULL;
    }
    
    RETURN (d);
}
    
info_data *
info_delete_comment (d)
    info_data *d;
{
//  char * tmp;
//  char * minne;
  char tom[]=" ";
  return info_change_comment(d,tom);
}


info_data *
info_create_comment (d, comment)
    info_data *d;
    char * comment;
{
  int i;
  int len;
  char *s;
  char *src;
  char *dst;
  
  len = 0;
  len += strlen (d->info[0]) + 1;
  for (i = 0; d->uname[i] != NULL; i++) {
    len += strlen (d->uname[i]) + 1;
  }
  len += strlen(comment) +1 ;
  
  s = malloc (len * sizeof(char));
  if (s == NULL)
    return NULL;
  
  dst = s;

  src = d->info[0];
  while ((*dst++ = *src++)) 
    ;
  *(dst -1 ) = ':';
  for (i=0; d->uname[i] != NULL; i++) {
    src = d->uname[i];
    while ((*dst++ = *src++))
      ;
    *(dst -1) = ',';
  }
  *(dst -1) = ':';
  
  src = comment;
  while ((*dst++ = *src++)) 
    ;
  
  *--dst = '\0';
  info_free_data(d);
  d = info_string_to_data(s);
  free(s);
    
  return d;
}

info_data *
info_change_comment (d, comment)
    info_data *d;
    char * comment;
{
  return   info_create_comment (d,comment);
}

info_data * 
info_add_name (d, uname)
    info_data *d;
    char * uname;

{
  /* We first create the new string "," separate
     and then put it to itemize 
     */
  int i;
  int len;
  char *s;
  char *src;
  char *dst;
  
  len = 0;
  len += strlen (d->info[0]) + 1;
  for (i = 0; d->uname[i] != NULL; i++) {
    if (strcmp(d->uname[i],uname) != 0)
      len += strlen (d->uname[i]) + 1;
  }
  len += strlen(uname) + 1;
  len += strlen(d->info[2])  + 1 ;
  
  s = malloc (len * sizeof(char));
  if (s == NULL)
    return NULL;
  
  dst = s;

  src = d->info[0];
  while ((*dst++ = *src++)) 
    ;
  *(dst -1 ) = ':';
  src = uname;
  while ((*dst++ = *src++))
    ;
  *(dst -1) = ',';
	
  for (i=0; d->uname[i] != NULL; i++) {
    if (strcmp(d->uname[i],uname) != 0) {
      src = d->uname[i];
      while ((*dst++ = *src++))
	;
      *(dst -1) = ',';
    }
  }
  *(dst -1) = ':';
  
  src = d->info[2];
  while ((*dst++ = *src++)) 
    ;
  
  *--dst = '\0';
  info_free_data(d);
  d = info_string_to_data(s);
  free(s);
  return d;
}

info_data * 
info_del_name (d, uname)
    info_data *d;
    char * uname;
{
   /* We first create the new string "," separate
     and then put it to itemize 
     */

  int i;
  int len;
  char *s;
  char *src;
  char *dst;
  
  len = 0;
  len += strlen (d->info[0]) + 1;
  for (i = 0; d->uname[i] != NULL; i++) {
    if (strcmp(d->uname[i],uname) != 0)
      len += strlen (d->uname[i]) + 1;
  }
  len += strlen(d->info[2])  + 1 ;
  
  s = malloc (len * sizeof(char));
  if (s == NULL)
    return NULL;
  
  dst = s;

  src = d->info[0];
  while ((*dst++ = *src++)) 
    ;
  *(dst -1 ) = ':';
  for (i=0; d->uname[i] != NULL; i++) {
    if (strcmp(d->uname[i],uname) != 0) {
      src = d->uname[i];
      while ((*dst++ = *src++))
	;
      *(dst -1) = ',';
    }
  }
  *(dst -1) = ':';
  
  src = d->info[2];
  while ((*dst++ = *src++)) 
    ;
  
  *--dst = '\0';
  info_free_data(d);
  d = info_string_to_data(s);
  free(s);
  return d;
}

info_data *
info_make_empty(pnr)
     char * pnr;
{
  char *tmp;
  char *i;
  info_data * toret;
  
  i = tmp = (char *) malloc (sizeof(char) * (strlen(pnr) + 5));
  /* persnr: : '\0' */
  if (tmp == NULL)
    return NULL;
  
  strcpy (i, pnr);
  i += strlen(pnr);
  strcpy (i,": : ");
  toret = info_string_to_data(tmp);
  free(tmp);
  return toret;
}

void
info_free_data (d)
    info_data *d;
{
    if (d->uname)
      itemfree (d->uname);
    if (d->info)
      itemfree (d->info);
    free (d);
}

char *
info_get_names(info_data *d) 
{
  int len;
  char *s;
  char *dst;
  char *src;
  int i;
  
  if (strcmp(d->info[1]," ") == 0) {
    len = 1;
    s = malloc (len * sizeof(char));
    if (s == NULL)
      return NULL;
    *s = '\0';
    return s;
  }

  len = 0;
  for (i = 0; d->uname[i] != NULL && strcmp(d->uname[i], " ") != 0; i++) {
    len += strlen(d->uname[i]) +1;
  }
  
  if (len == 0)
    return NULL;
  
  s = malloc (len * sizeof(char));
  if (s == NULL)
    return NULL;
  
  dst = s;
  
  for (i = 0; d->uname[i] != NULL && strcmp(d->uname[i], " ") != 0; i++) {
    src = d->uname[i];
    while ((*dst++ = *src++))
	;
    *(dst -1) = ',';
  }
  *--dst = '\0';

  return s;
}

char *
info_get_comment(info_data *d) 
{
  int len;
  char *s;
  char *dst;
  char *src;
//  int i;
  
  if (d->info[2] == NULL)
    return NULL;
  if (strcmp(d->info[2]," ") == 0) {
    len = 1;
    s = malloc (len * sizeof(char));
    if (s == NULL)
      return NULL;
    *s = '\0';
    return s;
  }
  len = strlen(d->info[2]) + 1;
  s = malloc (len * sizeof(char));
  dst = s;
  
  src = d->info[2];
  while ((*dst++ = *src++))
    ; 
  *--dst = '\0';
  return s;
}
     


int
info_empty (d)
     info_data *d;
{
  return(strcmp(d->uname[0]," ")  == 0 && strcmp(d->info[2]," ") == 0);


}




