
#include <stdio.h>
#include <stdlib.h>
#include <string.h> 
//#include <ndbm.h>
#include <gdbm.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include <krb.h>
#include <des.h>

#include <unistd.h>
#include <z/z.h>

struct local_slot
{
    char *		passwd;
    char *		ptmp;
    FILE *		fp;
    int			prefetch_uid;
    char 		prefetch_line[PW_BUFLEN];
};

struct remote_slot
{
    char *		servername;
    char *		shortname;
    CREDENTIALS *	cred;
    des_key_schedule	sched;
    int			socket;
    struct sockaddr_in	clnt_addr;
    struct sockaddr_in	serv_addr;
    char *		serv_realm;
    int			nextid;
    int			prefetch_uid;
    char 		prefetch_line[PW_BUFLEN];
};

struct ndbm_slot
{
  char *		byuid;
  char *		byname;
  GDBM_FILE 	        uid_db;
  GDBM_FILE 	        name_db;
  //  char *                pnrbyuid;
  char *                pnrbyname;
  char *                infobypnr;
  GDBM_FILE 	        pnrbyname_db;
  GDBM_FILE 	        infobypnr_db;
  time_t		last_mod;
  char *		free;
  int			prefetch_uid;
  char 		prefetch_line[PW_BUFLEN];
};

struct slot
{
    bool	active;		/* True if the slot is in use */
    int		type;		/* PW_LOCAL or PW_REMOTE */
    int		flags;
    union 
    {
	struct local_slot	local;
	struct remote_slot	remote;
	struct ndbm_slot	ndbm;
    } module;
};
typedef struct slot slot;


/* The descriptor table */
extern slot _pw_dtab[];
