
/* error.c
 *
 */

#include <stdio.h>
#include <varargs.h>
#include <syslog.h>
#include <errno.h>
#include "error.h"

extern char *progname;
void (*abort_hook) ();

#ifndef HAVE_SYS_ERRLIST_DECLARATION
extern char *sys_errlist[];
#endif 

#ifndef HAVE_SYS_NERR_DECLARATION
extern int sys_nerr;
#endif

void
my_warning (va_alist)
    va_dcl
{
    char	*fmt;
    va_list	args;

    va_start (args);
    fmt = va_arg (args, char *);
    fprintf (stderr, "%s: warning: ", progname);
    (void) vfprintf (stderr, fmt, args);
    fputc ('\n', stderr);
    va_end (args);
}

void
my_error (va_alist)
    va_dcl
{
    char	*fmt;
    va_list	args;

    va_start (args);
    fmt = va_arg (args, char *);
    fprintf (stderr, "%s: ", progname);
    (void) vfprintf (stderr, fmt, args);
    fputc ('\n', stderr);
    va_end (args);
}

void
my_abort (va_alist)
    va_dcl
{
    char	*fmt;
    va_list	args;

    va_start (args);
    fmt = va_arg (args, char *);
    fprintf (stderr, "%s: ", progname);
    (void) vfprintf (stderr, fmt, args);
    fputc ('\n', stderr);
    if (abort_hook != NULL)
	(*abort_hook) ();
    exit (1);
    va_end (args);
}

void
my_syswarn (va_alist)
    va_dcl
{
    char	*fmt;
    va_list	args;

    va_start (args);
    fmt = va_arg (args, char *);
    fprintf (stderr, "%s: warning: ", progname);
    (void) vfprintf (stderr, fmt, args);
    if (errno < 0 || errno >= sys_nerr)
	fprintf (stderr, ": Unknown error (%d)\n", errno);
    else
	fprintf (stderr, ": %s\n", sys_errlist[errno]);
    va_end (args);
}

void
my_syserr (va_alist)
    va_dcl
{
    char	*fmt;
    va_list	args;

    va_start (args);
    fmt = va_arg (args, char *);
    fprintf (stderr, "%s: ", progname);
    (void) vfprintf (stderr, fmt, args);
    if (errno < 0 || errno >= sys_nerr)
	fprintf (stderr, ": Unknown error (%d)\n", errno);
    else
	fprintf (stderr, ": %s\n", sys_errlist[errno]);
    va_end (args);
}

void
my_sysabort (va_alist)
    va_dcl
{
    char		*fmt;
    va_list		args;

    va_start (args);
    fmt = va_arg (args, char *);
    fprintf (stderr, "%s: ", progname);
    (void) vfprintf (stderr, fmt, args);
    if (errno < 0 || errno >= sys_nerr)
	fprintf (stderr, ": Unknown error (%d)\n", errno);
    else
	fprintf (stderr, ": %s\n", sys_errlist[errno]);
    if (abort_hook != NULL)
	(*abort_hook) ();
    exit (1);
    va_end (args);
}



