 
#include <stdio.h>
#include <z/bool.h>
#include <z/error.h>
#include <z/str.h>
#include <pw.h>

char *progname = "pwkadd";

extern char *index ();
extern int errno;

int
main (argc, argv)
    int argc;
    char *argv[];
{
    int res;
    FILE *ifp;
    FILE *ofp;
    char logname[1024];
    char *cp;
    char *passwd;
    int xerrno;
	    
    if (argc != 3)
    {
	fprintf (stderr, "usage: %s infile outfile\n", progname);
	exit (1);
    }

    ifp = fopen (argv[1], "r");
    if (ifp == NULL)
	my_sysabort ("Can't open infile: %s", argv[1]);

    umask (077);
    ofp = fopen (argv[2], "w");
    if (ofp == NULL)
	my_sysabort ("Can't open outfile: %s", argv[2]);

    pw_kadm_usr_init (30);

    while (fgets (logname, 1024, ifp) != NULL)
    {
	stripline (logname);
	if (commentline (logname))
	    continue;

	cp = index (logname, ':');
	if (cp != NULL)
	    *cp = '\0';

	passwd = pw_mkpasswd (logname);

	pw_kadm_add_new_key (logname, passwd);
	if (pw_errno == PW_EKADMEXISTS) {
	  fprintf(stderr, "Principal %s already exists. Only changing password.\n", logname);
	  pw_kadm_change_password (logname, passwd);
	}
	if (pw_errno != PW_EOK)
	{
	    bzero (passwd, strlen (passwd));
	    pw_abort ();
	}

	res = fprintf (ofp, "%s:%s\n", logname, passwd);
	if (res != EOF)
	    fflush (ofp);
	if (res == EOF)
	{
	    xerrno = errno;
	    pw_kadm_zap_principal (logname);
	    errno = xerrno;
	    my_sysabort ("Error writing outfile: %s", argv[2]);
	}
	
	free (passwd);
    }

    if (ferror (ifp))
	my_sysabort ("Error while reading infile: %s", argv[1]);
    fclose (ifp);

    res = fclose (ofp);
    if (res == EOF)
    {
	xerrno = errno;
	pw_kadm_zap_principal (logname);
	errno = xerrno;
	my_sysabort ("Error writing outfile: %s", argv[2]);
    }

    pw_kadm_destroy_ticket ();

    exit (0);
}
