
/* pwedit.c
 *
 */

#include <stdio.h>
#include <z/bool.h>
#include <z/error.h>
#include <pw.h>
#include "../../readline/readline.h"

char *progname = "pwedit";
char *old_line;
Function insert_old_line;

int
main (argc, argv)
    int argc;
    char *argv[];
{
    int res;
    int d;
    char *old, *new;

    d = pw_args (&argc, &argv);
    old = pw_getpwarg (d, &argc, &argv);

    if (old == NULL)
	pw_abort ();
    
    old_line = old;
    rl_startup_hook = insert_old_line;

    new = readline ("");

    if (new == NULL)
	exit (1);

    if (strcmp (old, new) == 0)
	my_abort ("no change");

    pw_update (d, old, new);
    if (pw_errno != PW_EOK)
	pw_abort ();

    exit (0);
}

int
insert_old_line ()
{
    strcpy (rl_line_buffer, old_line);
    rl_point = 0;
    rl_end = strlen (old_line);
}
