#!/usr/local/bin/bash

PATH=/usr/afsws/bin:/usr/afsws/etc:/usr/bin:${PATH}

cell=e.kth.se

echo "starting delete-afsuser.sh... arguments $*"

function usage () { echo usage: $0 "user homedir"; exit 1; }

if test $# != 2;
then
  usage
fi

id=$1
homedir=$2

if [ "X$id" = "X" -o "X$homedir" = "X" ]; then
    echo "missing argument"
    exit 1;
fi

rwhomedir=/afs/.$cell/$homedir
rwparentdir=`dirname $rwhomedir`

parentvolume=`fs lq $rwparentdir | tail -1 | cut -d" " -f1`
homevolume=`fs lq $rwhomedir | tail -1 | cut -d" " -f1`



echo deleting user $id ...

echo removing mountpoint
fs rmm $rwhomedir || exit 1

echo removing homevolume
vos remove -id $homevolume || exit 1

echo removing pts-entries
pts delete $id || exit 1
pts delete $id:remote-users || exit 1

echo "releasing volume $parentvolume"
vos rele $parentvolume

exit 0
