/* gecos.c
 *
 */

#include <stdio.h>
#include <string.h>
#include <z/bool.h>
#include <z/error.h>
#include <z/date.h>
#include <string.h>
#include "pw.h"
#include "gecos.h"

bool
gc_user_editable (int fieldno)
{
    if (fieldno == GC_OFFICEPHONE)
	return TRUE;

    if (fieldno == GC_HOMEPHONE)
	return TRUE;

    if (fieldno == GC_MAILFORWARD)
	return TRUE;

    return FALSE;
}

char *
gc_prompt (int fieldno)
{
    switch (fieldno)
    {
    case GC_FULLNAME:
	return "Fullname";

    case GC_ORGANIZATION:
	return "Organization";

    case GC_OFFICEPHONE:
	return "Office phone";

    case GC_HOMEPHONE:
	return "Home phone";

    case GC_COMMENT:
	return "Comment";

    case GC_CREATIONDATE:
	return "Creation date";

    case GC_CREATOR:
	return "Creator";

    case GC_EXPIRATIONDATE:
	return "Expiration date";

    case GC_MAILFORWARD:
	return "Mail forward address";

    case GC_ADMINFO:
	return "Administrative code";

    default:
	return NULL;
    }
}

int
gc_syntax_field (char *s,int level, int i)
{

    if (index (s, ':') != NULL)
	return PW_SYNTAX_ECOLON;

    if (index (s, ',') != NULL)
	return GC_SYNTAX_ECOMMA;

    if (level < PW_SYNTAX_NORMAL)
	return PW_SYNTAX_EOK;

    switch (i)
    {
    case GC_FULLNAME:
	/** Not empty **/
	/** Valid chars **/
	return PW_SYNTAX_EOK;

    case GC_ORGANIZATION:
	/** Not empty **/
	/** Valid chars **/
	return PW_SYNTAX_EOK;

    case GC_OFFICEPHONE:
	/** Valid chars **/
	return PW_SYNTAX_EOK;

    case GC_HOMEPHONE:
	/** Valid chars **/
	return PW_SYNTAX_EOK;

    case GC_COMMENT:
	/** Valid chars **/
	return PW_SYNTAX_EOK;

    case GC_CREATIONDATE:
	if (date2int (s) == -1)
	    return GC_SYNTAX_ECREATIONDATE;
	return PW_SYNTAX_EOK;

    case GC_CREATOR:
	/** Not empty **/
	/** Valid chars **/
	return PW_SYNTAX_EOK;

    case GC_EXPIRATIONDATE:
	if (date2int (s) == -1)
	    return GC_SYNTAX_EEXPIRATIONDATE;
	return PW_SYNTAX_EOK;

    case GC_MAILFORWARD:
	/** Valid chars **/
	return PW_SYNTAX_EOK;

    case GC_ADMINFO:
	/** Valid state **/
	/** Valid chars **/
	return PW_SYNTAX_EOK;

    default:
      // what to return? WE don't have dny PW_SYNTAX_NOT_OK?  
      //NFIELDS Sounds god
	return GC_SYNTAX_ENFIELDS;
    }


}




