
/* cleanup.c
 *
 */

#define NULL 0
#define STACKSIZE 1024

static void (*funcs[STACKSIZE]) ();
static char *args[STACKSIZE];
static int sp = 1;

void
cleanup_push (func, arg)
    void (*func) ();
    char *arg;
{
    funcs[sp] = func;
    args[sp] = arg;
    sp++;
}

void
cleanup_pop ()
{
    sp--;
}

void
cleanup_mark ()
{
    funcs[sp] = NULL;
    sp++;
}

void
cleanup ()
{
    while (funcs[--sp] != NULL)
	(*funcs[sp]) (args[sp]);
    if (sp == 0)
	sp = 1;
}

void
cleanup_cancel ()
{
    while (funcs[--sp] != NULL)
	;
    if (sp == 0)
	sp = 1;
}

void
cleanup_all ()
{
    while (sp != 1)
	cleanup ();
}

void
cleanup_cancel_all ()
{
    while (sp != 1)
	cleanup_cancel ();
}

char *
cleanup_malloc (amount)
    int amount;
{
    char *new;
    extern char *malloc ();
    extern void *free ();

    new = (char *) malloc (amount);
    if (new == NULL)
    {
	cleanup ();
	return NULL;
    }
    else
    {
	cleanup_push (free, new);
	return new;
    }
}
