extern char *alloc ();
extern void alloc_set_errhandler ();
extern char *basename ();
extern char *dirname ();
extern char *samedir ();

#ifndef __z_bool_h
#define __z_bool_h

typedef int bool;

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE (!FALSE)
#endif

#endif
extern void cleanup_push ();
extern void cleanup_pop ();
extern void cleanup_mark ();
extern void cleanup ();
extern void cleanup_cancel ();
extern void cleanup_all ();
extern void cleanup_cancel_all ();
extern char *cleanup_malloc ();

#define RETURN(exp) \
    do { cleanup_cancel (); return (exp); } while (0)
#define FAIL(exp) \
    do { cleanup (); return (exp); } while (0)
extern int date2int ();
extern char *date2str ();
extern char *datetoday ();


#ifndef __z_error_h
#define __z_error_h

#define __ASSERTFMT__ \
"\nProgram bug detected at line %d in sourcefile %s (author apologizes)"
#define ASSERT(x) {if(!(x)){my_abort(__ASSERTFMT__,__LINE__,__FILE__);}}

extern void my_warning ();
extern void my_error ();
extern void my_abort ();
extern void my_syswarn ();
extern void my_syserr ();
extern void my_sysabort ();

extern char *progname;
extern void (*abort_hook) ();

#endif

#ifndef __z_file_h
#define __z_file_h

#define FILE_EOK	0
#define FILE_EOPEN	-1
#define FILE_EREAD	-2
#define FILE_ECREAT	-3
#define FILE_EWRITE	-4

#define FILE_BUFLEN	1024

extern int eachline ();
extern int mapline ();

#endif

#ifndef __z_itemize_h
#define __z_itemize_h

#define ITEMV_SIZE	128

extern char **itemize ();
extern char **nitemize ();
extern char **_itemize ();
extern void itemfree ();
extern void myitemfree ();
extern char *deitemize ();
extern int itemcount ();

#endif

extern char *duplen ();
extern char *dupsub ();
extern void stripline ();
extern bool commentline ();
extern void lowcase ();
extern void upcase ();
