
#include <stdio.h>
#include <ctype.h>

#include <z/bool.h>
#include <z/error.h>
#include <pw.h>

char *progname = "pwNeXT";

int nada;
int next;
int nextuid;

char *cats[] =
{
    "ASS", "C2M2", "CVAP", "FYSIK4", "IPLAB", "KTHMATTE", "MATH",
    "MECH", "NADA", "NUM", "SANS", "SICS", "STAFF", "SUMATTE",
    "TDS", "TEACH", "THEORY",
    "D83", "D84", "D85", "D86", "D87", "D88", "D89", "D90", "D91", "D92",
    "MD83", "MD84", "MD85", "MD86", "MD87", "MD88",
    "NV89", "NV90", "NV91",  "NV92",
    "SU89", "SU90", "SU91", "SU92",
    "MT87", "MT88",
    NULL
};


bool
is_next_user (data)
    pw_data *data;
{
    int i;

    if (data->gcv == NULL)
	return FALSE;

    for (i = 0; cats[i]; i++)
	if (strcmp (data->gcv[GC_ORGANIZATION], cats[i]) == 0)
	    return TRUE;

    return FALSE;
}

void
doit (line)
    char *line;
{
    pw_data *data;
    char *tmp;
    char *new;
    char buf[512];
    int uid;
    int u;

    data = pw_string_to_data (line);

    uid = atoi (data->pwv[PW_UID]);

    if (is_next_user (data))
    {
	tmp = data->pwv[PW_PASSWD];
	data->pwv[PW_PASSWD] = "";
	new = pw_data_to_string (data);
	strcpy (buf, new);
	free (new);
	data->pwv[PW_PASSWD] = tmp;
    }
    else
    {
	strcpy (buf, line);
    }

    while ((u = pw_nextuid (next, nextuid)) < uid && u != -1)
    {
	tmp = pw_prefetched (next);
	pw_delete (next, tmp);
	if (pw_errno != PW_EOK)
	{
	    fprintf (stderr, "Can't DELETE %d\n", u);
	    pw_abort ();
	}
	nextuid = u + 1;
    }

    if (u == uid)
    {
	tmp = pw_prefetched (next);
	if (strcmp (tmp, buf) != 0)
	{
	    pw_update (next, tmp, buf);
	    if (pw_errno != PW_EOK)
	    {
		fprintf (stderr, "Can't UPDATE %d\n", u);
		pw_abort ();
	    }
	}
    }
    else
    {
	pw_create (next, buf);
	if (pw_errno != PW_EOK)
	{
	    fprintf (stderr, "Can't CREATE %d\n", uid);
	    pw_abort ();
	}
    }

    nextuid = uid + 1;

    pw_free_data (data);
}

main (argc, argv)
    int argc;
    char *argv[];
{
    int uid;
    int u;
    char *tmp;
    int result;
    int len;
    int i;

    nada = pw_args (&argc, &argv);

    if (argc != 1)
    {
	fprintf (stderr, "usage: pwNeXT\n");
	exit (1);
    }

    next = pw_open ("/var/yp/next.nada.kth.se/passwd", PW_NDBM, PW_FSLOPPY);
    if (next == -1)
	pw_abort ();

    nextuid = 0;
    pw_foreach (nada, doit);

    if (pw_errno != PW_EOK)
	pw_abort ();

    while ((u = pw_nextuid (next, nextuid)) != -1)
    {
	tmp = pw_prefetched (next);
	pw_delete (next, tmp);
	if (pw_errno != PW_EOK)
	{
	    fprintf (stderr, "Can't DELETE %d\n", u);
	    pw_abort ();
	}
	nextuid = u + 1;
    }

    pw_close (nada);
    pw_close (next);

    exit (0);
}
