
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <z/bool.h>
#include <z/error.h>
#include <z/str.h>
#include <z/itemize.h>
#include <pw.h>

char *progname = "pnrcreate";
bool nohyphen = FALSE;

int
main (argc, argv)
    int argc;
    char *argv[];
{
  int d;
  char *infile;
  FILE *ifp;
  char buf[1024];
  char *pnr;
  char *logname;
  char **item;
	    
  d = pw_open (NULL, PW_REMOTE, 0);
  if (d == -1)
    pw_abort ();

  if (argc != 2)
    {
      fprintf (stderr, "usage: %s org infile", progname);
      exit (1);
    }

  infile = strdup (argv[1]);
  ifp = fopen (infile, "r");
  if (ifp == NULL)
    my_sysabort ("Can't open infile: %s", infile);

  while (fgets (buf, 1024, ifp) != NULL)
    {
      stripline (buf);
      if (commentline (buf))
	continue;
	
      item = itemize(buf,"\t");
      if (item == NULL )
	continue;
	
      if (item[0] == NULL)
	continue;
      if (item[1] == NULL)
	continue;
      logname = strdup(item[1]);
      /* strdup (buf); */
      pnr = NULL;

      pnr = strdup (item[0]);
	
      if (pnr != NULL) {
	printf ("Pnr : %s\t username %s\n",pnr, logname);
 	pnr_create(d, pnr,logname);
	if (pw_errno != PW_EOK) {
	  my_error ("Can't insert new user into pnr database");
	  pw_abort ();
	}
	  
      }
      fflush (stdout);
	
	
      
      free (logname);
      free (pnr);
    }
  
  if (ferror (ifp))
    my_sysabort ("Error while reading infile: %s", infile);
  fclose (ifp);
  
  
  exit (0);
}
