#!/usr/local/bin/bash

PATH=/usr/local/staff/bin:/usr/athena/bin:$PATH

hesioddir=/var/nameserver
dbmdir=/var/chpass
nameservers="heimdal.e.kth.se malt.e.kth.se"
mailhub=elixir.e.kth.se


if [ -f $dbmdir/pwpropagate.done -a \
     ! $dbmdir/passwd.byname.pag -nt $dbmdir/pwpropagate.done ]; then
  echo "Database has not changed."
  exit 0
fi

echo "Database has changed!"

for nameserver in $nameservers ; do
  for i in passwd.db pobox.db ; do
    echo "Pushing $i to $nameserver"
    pwmkhesiod $i | rsh $nameserver 'cat >' "$hesioddir/$i"
  done
  echo "Restarting named on $nameserver..."
  rsh $nameserver 'kill -HUP `cat /etc/named.pid`'
  sleep 5	#give the nameserver a chance to reload properly
done

echo "Pushing aliases file to $mailhub"
pwmkhesiod aliases | cat $dbmdir/aliases.local - | rsh $mailhub 'cat > /etc/aliases'
echo "Rebuilding aliases file on $mailhub"
rsh $mailhub /usr/ucb/newaliases

touch $dbmdir/pwpropagate.done

exit 0
