
/* chpobox.c
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/param.h>
#include <pwd.h>
#include <grp.h>
#include <string.h>
#include <strings.h>
#include "../../readline/readline.h"
#include <z/bool.h>
#include <z/error.h>
#include <z/file.h>
#include <z/itemize.h>
#include <pw.h>

extern char *getpass ();

char *progname = "chpobox";
char *chpobox ();

int
main (argc, argv)
    int argc;
    char *argv[];
{
    int res;			/* Result code (various uses) */
    int d;			/* Descriptor for PW database */
    char *old;			/* Old passwd(5)-line (what to change from) */
    char *new;			/* New passwd(5)-line (what to change to) */
    char *logname;
    struct passwd *pwd;
    extern char *getlogin ();
    extern char *getenv ();
    
    d = pw_args (&argc, &argv);

    if (argc == 1)
    {
	logname = getlogin ();
	if (logname == NULL)
	    logname = getenv ("USER");
	if (logname != NULL)
	{
	    pwd = getpwnam (logname);
	    if (pwd == NULL)
		my_abort ("Who are you? (User %s is not known)", logname);
	}
	else
	{
	    pwd = getpwuid (getuid ());
	    if (pwd == NULL)
		my_abort ("Who are you? (Uid %d is not known)", getuid ());
	}

	old = pw_getpwnam (d, pwd->pw_name);
    }
    else
	old = pw_getpwarg (d, &argc, &argv);
    if (old == NULL)
        pw_abort ();
    
    new = chpobox (old);

    if (strcmp (old, new) == 0)
	my_abort ("No change");

    pw_update (d, old, new);
    if (pw_errno != PW_EOK)
	pw_abort ();

    exit (0);
}

static char *xold;

insert_old ()
{
    strcpy (rl_line_buffer, xold);
    rl_point = 0;
    rl_end = strlen (xold);
}

char *
chpobox (old)
    char *old;
{
    int res;
    pw_data *pwd;
    char *new;
    char prompt[256];
    char *cp;

    pwd = pw_string_to_data (old);
    if (pwd == NULL)
	my_abort ("Memory allocation fails");

    if ((res = pw_syntax (pwd, PW_SYNTAX_NORMAL)) != PW_SYNTAX_EOK)
	my_warning ("Syntax error: %s", pw_syntax_message (res));
    

    printf ("Changing mail forwarding address for \"%s\"\n", pwd->pwv[PW_NAME]);

    rl_startup_hook = insert_old;

    xold = pwd->gcv[GC_MAILFORWARD];
	sprintf (prompt, "%s: ", gc_prompt (GC_MAILFORWARD));

retry:
    new = readline (prompt);
    
    if (new == NULL)
      exit (1);

    while (*new == ' ')
      new++;
    cp = new + strlen (new);
    while (*--cp == ' ')
      *cp = '\0';

    if (strcmp (old, new) != 0)
      {
	res = gc_syntax_field (new, PW_SYNTAX_NORMAL, GC_MAILFORWARD);
	if (res != PW_SYNTAX_EOK)
	  {
	    printf ("%s\n", pw_syntax_message (res));
	    goto retry;
	  }
      }
	
    pwd->gcv[GC_MAILFORWARD] = strdup (new);

    return pw_data_to_string (pwd);
}

