
/* kadm.c
 *
 * Simplified administration operations on the Kerberos database. They only
 * operate on null instances in the default realm.
 */

#include <stdio.h>
#include <pwd.h>
#include <unistd.h>
#include <string.h>
#include <sys/param.h>

#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif

#include <netinet/in.h>
#include <krb5.h>
#include <kadm5/admin.h>
#include <kadm5/kadm5_err.h>
#include <kadm_err.h>

#include <z/bool.h>
#include <z/error.h>

#include "pw.h"
#include "gpw_locl.h"

static char kadm_tkt_string[MAXPATHLEN];
static char saved_tkt_string[MAXPATHLEN];

static char *client_name;
kadm5_config_params conf;

static void
save_tkt_string ()
{
#if 0
    strcpy (saved_tkt_string, tkt_string ());
    krb_set_tkt_string (kadm_tkt_string);
#endif
}

static void
restore_tkt_string ()
{
#if 0
    krb_set_tkt_string (saved_tkt_string);
#endif
}



#if 0
static char realm[REALM_SZ];

static void
kadm_init (principal, instance, passwd, srvtab, lifetime)
    char *principal;
    char *instance;
    char *passwd;
    char *srvtab;
    int lifetime;
{
    int res;
    CREDENTIALS cred;


    res = krb_get_lrealm (realm, 1);

    if (res != KSUCCESS)
	strcpy (realm, KRB_REALM);

    res = kadm_init_link (PWSERV_NAME, KRB_MASTER, realm);
    if (res != KADM_SUCCESS)
    {
	pw_errno = PW_EKADMLINK;
	pw_krberr = res;
	return;
    }
    
    res = krb_get_cred (PWSERV_NAME, KADM_SINST, realm, &cred);
    if (res == KSUCCESS
    && time (0) < cred.issue_date + 5 * 60 * cred.lifetime + 15)
    {
	pw_errno = PW_EOK;
	return;
    }


    if (lifetime <= 0)
	lifetime = 1;
    else if (lifetime % 5 == 0)
	lifetime /= 5;
    else
	lifetime = lifetime / 5 + 1;

    if (passwd != NULL)
	res = krb_get_pw_in_tkt (principal, instance, realm,
				 PWSERV_NAME, KADM_SINST, lifetime, passwd);
    else
	res = krb_get_svc_in_tkt (principal, instance, realm,
				  PWSERV_NAME, KADM_SINST, lifetime, srvtab);
	
    if (res != KSUCCESS)
    {
	pw_errno = PW_EKADMINTKT;
	pw_krberr = res;
	return;
    }
}

#endif

static void
kadm_init (principal, instance, passwd, srvtab, lifetime)
    char *principal;
    char *instance;
    char *passwd;
    char *srvtab;
    int lifetime;
{
#if 0
    krb5_context context;
    int ret;
    static char *client_name;
    kadm5_config_params conf;
    void *kadm_handle;

    pw_errno = PW_EOK;
    ret = krb5_init_context(&context);

    if (ret)
    {
        pw_errno = PW_EKADMLINK;
        pw_krberr = ret;
        return;
    }

    ret = kadm5_c_init_with_password_ctx(context,
					 client_name,
					 NULL,
					 KADM5_ADMIN_SERVICE,
					 &conf, 0, 0,
					 &kadm_handle);

    if(ret)
    {
        pw_errno = PW_EKADMLINK;
        pw_krberr = ret;
        return;
    }
	
#endif
}

void
pw_kadm_init (principal, instance, passwd, lifetime)
    char *principal;
    char *instance;
    char *passwd;
    int lifetime;
{
#if 0
    sprintf (kadm_tkt_string, "/tmp/tkt_pwkadm_%s.%s", principal, instance);
    save_tkt_string ();
    kadm_init (principal, instance, passwd, NULL, lifetime);
    restore_tkt_string ();
#endif
}


void
pw_kadm_svc_init (principal, instance, srvtab)
    char *principal;
    char *instance;
    char *srvtab;
{
#if 0
    sprintf (kadm_tkt_string, "/tmp/tkt_pwkadm.%d", getpid ());
    save_tkt_string ();
#endif
    kadm_init (principal, instance, NULL, srvtab, 480);
#if 0
    restore_tkt_string ();
#endif
}


void
pw_kadm_usr_init (lifetime)
{

    int ret;
    if(context == NULL) {
	ret = krb5_init_context(&context);
	if (ret)
	    errx (1, "krb5_init_context failed: %d", ret);

	ret = kadm5_c_init_with_password_ctx(context,
                                             client_name,
                                             NULL,
                                             KADM5_ADMIN_SERVICE,
                                             &conf, 0, 0,
                                             &kadm_handle);
	if(ret)
	    krb5_err(context, 1, ret, "kadm5_init_with_password");


    }

}


void
pw_kadm_destroy_ticket ()
{
#if 0
    save_tkt_string ();
    dest_tkt ();
    pw_errno = PW_EOK;
    restore_tkt_string ();
#endif
}


/* add_new_key
 *
 * Add the principal to the Kerberos database. If the principal already
 * exists, but is expired, it is reused. 
 */
void
pw_kadm_add_new_key (name, passwd)
    char *name;
    char *passwd;
{
    printf("pw_kadm_add_new_key is not implemented. Add your kerberos key manually\n");

    return;

#if 0
    int res;
    Kadm_vals old, new;
    unsigned char fields[4];
    des_cblock deskey;


    save_tkt_string ();

    bzero (&old, sizeof (old));

    strcpy (old.name, name);
    SET_FIELD (KADM_NAME, old.fields);

    old.instance[0] = '\0';
    SET_FIELD (KADM_INST, old.fields);

    bzero (fields, 4);
    SET_FIELD (KADM_EXPDATE, fields);

    new = old;
	
    res = kadm_get (&old, fields);
    if ((res != (int)KADM_SUCCESS) && (res != (int)KADM_NOENTRY))
    {
	pw_errno = PW_EKADMOP;
	pw_krberr = res;
	restore_tkt_string ();
	return;
    }
    
    new.exp_date = time(0) + 315569520L;  /* Ten years */
    SET_FIELD (KADM_EXPDATE, new.fields);

    des_string_to_key (passwd, deskey);
    bcopy ((char *) deskey, (char *) &new.key_low, 4);
    new.key_low = htonl (new.key_low);
    bcopy (((char *) deskey) + 4, (char *) &new.key_high, 4);
    new.key_high = htonl (new.key_high);
    SET_FIELD (KADM_DESKEY, new.fields);

    if (res == KADM_SUCCESS)
    {
	if (old.exp_date > time(0))
	{
	    pw_errno = PW_EKADMEXISTS;
	    restore_tkt_string ();
	    return;
	}

	bzero (old.fields, 4);

	strcpy (old.name, name);
	SET_FIELD (KADM_NAME, old.fields);

	old.instance[0] = '\0';
	SET_FIELD (KADM_INST, old.fields);

	res = kadm_mod (&old, &new);
	if (res == KADM_SUCCESS)
	{
	    pw_errno = PW_EOK;
	    restore_tkt_string ();
	    return;
	}
	else
        {
	    pw_errno = PW_EKADMOP;
	    pw_krberr = res;
	    restore_tkt_string ();
	    return;
	}
    }
    else
    {
	res = kadm_add (&new);
	if (res != KADM_SUCCESS)
	{
	    pw_errno = PW_EKADMOP;
	    pw_krberr = res;
	    restore_tkt_string ();
	    return;
	}

	pw_errno = PW_EOK;
	restore_tkt_string ();
    }
#endif

}


/* change_password
 *
 * Change the password for the given principal. 
 */
void
pw_kadm_change_password (name, passwd)
    char *name;
    char *passwd;
{
    int res;

    krb5_principal princ;
    krb5_parse_name(context, name, &princ);

    res = set_password(princ, passwd);
    if (res)
    {
	pw_errno = PW_EKADMOP;
	pw_krberr = res;
	return;
    }
}


/* zap_principal
 *
 * Change the expiration date for the principal to one second ago. That is,
 * expire the principal. Kerberos does not support deletion of principals
 * because of certain security implications. 
 */
void
pw_kadm_zap_principal (name)
    char *name;
{
    int res;
    krb5_principal princ;

    krb5_parse_name(context, name, &princ);

    res = kadm5_delete_principal(kadm_handle, princ);
    if (res)
    {
	pw_errno = PW_EKADMOP;
	pw_krberr = res;
	return;
    }
}
