/* ndbm.c
 *
 */

/* changed from ndbm to gdbm
 * Need to free everything from gdbm_fetch
 */

#include <sys/time.h>
#include <z/bool.h>
#include <z/str.h>
#include <errno.h>
#include "pw.h"
#include "pw.H"
#include "ndbm.H"

void touch ();

void datum_free(datum  data)
{
  free(data.dptr);
}
/* _pw_ndbm_open
 *
 */
int
_pw_ndbm_open (d, dbname)
    int			d;		/* Descriptor */
    char *		dbname;		/* Name of NDBM-database */
{
//    int			res;		/* General return status */
    char *		byuid;
    char *		byname;
    GDBM_FILE 		uid_db;
    GDBM_FILE 		name_db;
    char *              pnrbyname;
    char *              infobypnr;
    GDBM_FILE 	        pnrbyname_db;
    GDBM_FILE 	        infobypnr_db;    
    int			uid;
    char *		uid_str;
    char *		uid_stop;
    datum		key;


    /* Default file is /var/yp/<NIS domain name>/passwd */

    if (dbname == NULL)
    {
	char *domain;
	char buf[256];

	if (yp_get_default_domain (&domain) != 0)
	{
	    pw_errno = PW_ENISDOMAIN;
	    return -1;
	}
	sprintf (buf, "/var/yp/%s/passwd", domain);
	dbname = strdup (buf);
    }

    /* Create filenames from database name */

    byuid = malloc (strlen (dbname) + 7);
    strcpy (byuid, dbname);
    strcat (byuid, ".byuid");

    byname = malloc (strlen (dbname) + 8);
    strcpy (byname, dbname);
    strcat (byname, ".byname");

    pnrbyname = malloc (strlen (dbname) + 11);
    strcpy (pnrbyname, dbname);
    strcat (pnrbyname, ".pnrbyname");

    infobypnr = malloc (strlen (dbname) + 11);
    strcpy (infobypnr, dbname);
    strcat (infobypnr, ".infobypnr");



    /* Open the databases */
    
    uid_db = gdbm_open (byuid, GDBM_BLOCK_SIZE, GDBM_WRCREAT , 0644,0);
    if (uid_db == NULL)
    {
	pw_errno = PW_EOPEN;
	return -1;
    }
    name_db = gdbm_open (byname, GDBM_BLOCK_SIZE, GDBM_WRCREAT , 0644,0);
    if (name_db == NULL)
    {
	gdbm_close (uid_db);
	pw_errno = PW_EOPEN;
	return -1;
    }

    pnrbyname_db = gdbm_open (pnrbyname,GDBM_BLOCK_SIZE, GDBM_WRCREAT , 0644,0); 
    if (pnrbyname_db == NULL)
      {
       	gdbm_close (uid_db);
	gdbm_close (name_db);
	pw_errno = PW_EOPEN;
	return -1;
    }

    infobypnr_db = gdbm_open (infobypnr,GDBM_BLOCK_SIZE, GDBM_WRCREAT , 0644,0);
    if (infobypnr_db == NULL)
      {
       	gdbm_close (uid_db);
	gdbm_close (name_db);
	gdbm_close (pnrbyname_db);
	pw_errno = PW_EOPEN;
	return -1;
    }


    /* Fill in table slot */

    _pw_dtab[d].module.ndbm.byuid = byuid;
    _pw_dtab[d].module.ndbm.byname = byname;
    _pw_dtab[d].module.ndbm.pnrbyname = pnrbyname;
    _pw_dtab[d].module.ndbm.infobypnr = infobypnr;
    _pw_dtab[d].module.ndbm.uid_db = uid_db;
    _pw_dtab[d].module.ndbm.name_db = name_db;
    _pw_dtab[d].module.ndbm.pnrbyname_db = pnrbyname_db;
    _pw_dtab[d].module.ndbm.infobypnr_db = infobypnr_db;

    _pw_dtab[d].module.ndbm.prefetch_uid = -1;
    _pw_dtab[d].module.ndbm.free = malloc (0x10000);
    for (uid = 0; uid < 0x10000; uid++)
	_pw_dtab[d].module.ndbm.free[uid] = TRUE;
    for (key = gdbm_firstkey (uid_db);
	 key.dptr != NULL;
	 key = gdbm_nextkey (uid_db, key))
    {
	uid_str = duplen (key.dptr, key.dsize);
	uid = strtol (uid_str, &uid_stop, 10);
	if (uid_stop - uid_str == key.dsize)
	    _pw_dtab[d].module.ndbm.free[uid] = FALSE;
	free (uid_str);
    }

    return 0;
}


/* _pw_ndbm_close
 *
 * Close a connection to a 'chpassd' server and release the descriptor.
 * Returns 0 on success and -1 on failure (in which case pw_errno
 * is set to indicate the error).
 */
void
_pw_ndbm_close (d)
    int d;
{
    gdbm_close (_pw_dtab[d].module.ndbm.uid_db);
    gdbm_close (_pw_dtab[d].module.ndbm.name_db);
    gdbm_close (_pw_dtab[d].module.ndbm.pnrbyname_db);
    gdbm_close (_pw_dtab[d].module.ndbm.infobypnr_db);
    free (_pw_dtab[d].module.ndbm.byuid);
    free (_pw_dtab[d].module.ndbm.byname);
    free (_pw_dtab[d].module.ndbm.pnrbyname);
    free (_pw_dtab[d].module.ndbm.infobypnr);
    free (_pw_dtab[d].module.ndbm.free);
    pw_errno = PW_EOK;
}

/* _pw_ndbm_create
 */
void
_pw_ndbm_create (d, new)
    int			d;
    char *		new;
{
    int			res;
    pw_data *		pwd;
    datum		uid_key;
    datum		name_key;
    datum		value;
    int			uid;
    int			level;
    

    /* Create key data */

    pwd = pw_string_to_data (new);
    if (pwd == NULL)
    {
	pw_errno = PW_EMEMORY;
	return;
    }
    level = (_pw_dtab[d].flags & PW_FSLOPPY) ?
	PW_SYNTAX_SLOPPY : PW_SYNTAX_NORMAL;
    if ((res = pw_syntax (pwd, level)) != PW_SYNTAX_EOK)
    {
	pw_free_data (pwd);
	pw_errno = PW_ENEWSYNTAX;
	pw_syntaxerr = res;
	return;
    }
    name_key.dptr = pwd->pwv[PW_NAME];
    name_key.dsize = strlen (pwd->pwv[PW_NAME]);
    uid_key.dptr = pwd->pwv[PW_UID];
    uid_key.dsize = strlen (pwd->pwv[PW_UID]);
    uid = atoi (pwd->pwv[PW_UID]);


    /* Check if name already exists */

    value = gdbm_fetch (_pw_dtab[d].module.ndbm.name_db, name_key);
    if (value.dptr != NULL)
    {
	/* If an exact match is found, don't treat this as an error */
	if (strncmp (value.dptr, new, value.dsize) != 0)
	    pw_errno = PW_ENAMEEXISTS;
	pw_free_data (pwd);
	datum_free(value);
	return;
    }
    datum_free(value);

    /* Check if uid already exists */


    if (gdbm_exists (_pw_dtab[d].module.ndbm.uid_db, uid_key))
    {
	pw_errno = PW_EUIDEXISTS;
	pw_free_data (pwd);
	return;
    }

    /* Store new entry in database */
    
    value.dptr = new;
    value.dsize = strlen (new);

    res = gdbm_store (_pw_dtab[d].module.ndbm.uid_db, uid_key, value, GDBM_REPLACE);
    if (res < 0)
    {
	pw_errno = PW_EWRITE;
	pw_free_data (pwd);
	return;
    }
    res = gdbm_store (_pw_dtab[d].module.ndbm.name_db, name_key, value, GDBM_REPLACE);
    if (res < 0)
    {
	res = errno;
	(void) gdbm_delete (_pw_dtab[d].module.ndbm.uid_db, uid_key);
	pw_errno = PW_EWRITE;
	errno = res;
	pw_free_data (pwd);
	return;
    }

    touch (_pw_dtab[d].module.ndbm.uid_db);
    touch (_pw_dtab[d].module.ndbm.name_db);

    _pw_dtab[d].module.ndbm.free[uid] = FALSE;
    pw_free_data (pwd);
}


/* _pw_ndbm_delete
 */
void
_pw_ndbm_delete (d, old)
    int			d;
    char *		old;
{
    int			res;
    pw_data *		pwd;
    datum		uid_key;
    datum		name_key;
    datum		value;
    int			uid;
    

    /* Create key data */

    pwd = pw_string_to_data (old);
    if (pwd == NULL)
    {
	pw_errno = PW_EMEMORY;
	return;
    }
    if ((res = pw_syntax (pwd, PW_SYNTAX_SLOPPY)) != PW_SYNTAX_EOK)
    {
	pw_free_data (pwd);
	pw_errno = PW_EOLDSYNTAX;
	pw_syntaxerr = res;
	return;
    }
    name_key.dptr = pwd->pwv[PW_NAME];
    name_key.dsize = strlen (pwd->pwv[PW_NAME]);
    uid_key.dptr = pwd->pwv[PW_UID];
    uid_key.dsize = strlen (pwd->pwv[PW_UID]);
    uid = atoi (pwd->pwv[PW_UID]);


    /* Check that old entry exists */

    value = gdbm_fetch (_pw_dtab[d].module.ndbm.name_db, name_key);
    if (value.dptr == NULL
    ||  strlen (old) != value.dsize
    ||  strncmp (old, value.dptr, value.dsize) != 0)
    {
	/* Not treating this as an error makes operation idempotent */
	/* pw_errno = PW_ENOTFOUND; */
      pw_free_data (pwd);
      datum_free(value);
      return;
    }
    
    datum_free(value);

    /* Do the deletion */

    (void) gdbm_delete (_pw_dtab[d].module.ndbm.name_db, name_key);
    (void) gdbm_delete (_pw_dtab[d].module.ndbm.uid_db, uid_key);
    (void) _pnr_ndbm_delete(d, pwd->pwv[PW_NAME]);
			    
    touch (_pw_dtab[d].module.ndbm.uid_db);
    touch (_pw_dtab[d].module.ndbm.name_db);

    _pw_dtab[d].module.ndbm.free[uid] = TRUE;
    pw_free_data (pwd);

}


/* _pw_ndbm_update
 */
void
_pw_ndbm_update (d, old, new)
     int			d;
     char *		old;
     char *		new;
{
  int 		res;
  pw_data *		pwd;
  int 		saved_errno;
  int			level;
  char *		oldline;
  char *		newline;
  int 		olduid;
  int			newuid;


  /* Check arguments */

  pwd = pw_string_to_data (old);
  if (pwd == NULL)
    {
      pw_errno = PW_EMEMORY;
      return;
    }
  if ((res = pw_syntax (pwd, PW_SYNTAX_SLOPPY)) != PW_SYNTAX_EOK)
    {
      pw_free_data (pwd);
      pw_errno = PW_EOLDSYNTAX;
      pw_syntaxerr = res;
      return;
    }
  olduid = atoi (pwd->pwv[PW_UID]);
  pw_free_data (pwd);

  pwd = pw_string_to_data (new);
  if (pwd == NULL)
    {
      pw_errno = PW_EMEMORY;
      return;
    }
  level = _pw_dtab[d].flags & PW_FSLOPPY ?
    PW_SYNTAX_SLOPPY : PW_SYNTAX_NORMAL;
  if ((res = pw_syntax (pwd, level)) != PW_SYNTAX_EOK)
    {
      pw_free_data (pwd);
      pw_errno = PW_ENEWSYNTAX;
      pw_syntaxerr = res;
      return;
    }
  newuid = atoi (pwd->pwv[PW_UID]);
  pw_free_data (pwd);

  oldline = _pw_ndbm_getpwuid (d, olduid);
  newline = _pw_ndbm_getpwuid (d, newuid);

  pw_errno = PW_EOK;

  if (oldline == NULL || strcmp (old, oldline) != 0)
    {
      if (strcmp (new, newline) != 0)
	pw_errno = PW_ENOTFOUND;
      if (oldline != NULL)
	free (oldline);
      if (newline != NULL)
	free (newline);
      return;
    }

  if (oldline != NULL)
    free (oldline);
  if (newline != NULL)
    free (newline);


  /* Do the work */

  _pw_ndbm_delete (d, old);
  if (pw_errno != PW_EOK)
    return;
  _pw_ndbm_create (d, new);
  if (pw_errno != PW_EOK)
    {
      saved_errno = pw_errno;
      _pw_ndbm_create (d, old);
      pw_errno = saved_errno;
    }
}


/* _pw_ndbm_firstuid
 */
int
_pw_ndbm_firstuid (d, target)
     int			d;
     int 		target;
{
  int		uid;
  char *	line;

  if (target < 0 || target > 65533)
    {
      pw_errno = PW_EBADUID;
      return -1;
    }
  uid = target;
  while (TRUE)
    {
      while (uid < 65534 && !_pw_dtab[d].module.ndbm.free[uid])
	++uid;
      if (uid == 65534)
	{
	  pw_errno = PW_ENOTFOUND;
	  return -1;
	}
      line = _pw_ndbm_getpwuid (d, uid);
      if (line == NULL)
	{
	  pw_errno = PW_EOK;
	  return uid;
	}
      else
	{
	  free (line);
	  uid++;
	}
    }
}


/* _pw_ndbm_nextuid
 */
int
_pw_ndbm_nextuid (d, target)
     int			d;
     int 		target;
{
  int		uid;
  char *	line;

  if (target < 0 || target > 65533)
    {
      pw_errno = PW_EBADUID;
      return -1;
    }
  uid = target;
  while (TRUE)
    {
      while (uid < 65534 && _pw_dtab[d].module.ndbm.free[uid])
	++uid;
      if (uid == 65534)
	{
	  pw_errno = PW_ENOTFOUND;
	  return -1;
	}
      line = _pw_ndbm_getpwuid (d, uid);
      if (line != NULL)
	{
	  _pw_dtab[d].module.ndbm.prefetch_uid = uid;
	  strcpy (_pw_dtab[d].module.ndbm.prefetch_line, line);
	  free (line);
	  return uid;
	}
      else
	uid++;
    }
}


char *
_pw_ndbm_prefetched (d)
     int d;
{
  if (_pw_dtab[d].module.ndbm.prefetch_uid == -1)
    return NULL;
  else
    return strdup (_pw_dtab[d].module.ndbm.prefetch_line);
}


/* _pw_ndbm_getpwuid
 */
char *
_pw_ndbm_getpwuid (d, uid)
     int			 d;
     int 		uid;
{
  static char uidstr[12];
  datum	key;
  datum	value;
  char *	line;

  (void) sprintf (uidstr, "%d", uid);
  key.dptr = uidstr;
  key.dsize = strlen (uidstr);
  value = gdbm_fetch (_pw_dtab[d].module.ndbm.uid_db, key);
  if (value.dptr == NULL)
    {
      pw_errno = PW_ENOTFOUND;
      return NULL;
    }

  line = malloc (value.dsize + 1);
  strncpy (line, value.dptr, value.dsize);
  line[value.dsize] = '\0';
  datum_free(value);
  return line;
}


/* _pw_ndbm_getpwnam
 */
char *
_pw_ndbm_getpwnam(d,name)

     int		d;
     char *	name;
{
  datum	key;
  datum	value;
  char *	line;

  key.dptr = name;
  key.dsize = strlen (name);
  value = gdbm_fetch (_pw_dtab[d].module.ndbm.name_db, key);
  if (value.dptr == NULL)
    {
      pw_errno = PW_ENOTFOUND;
      return NULL;
    }

  line = malloc (value.dsize + 1);
  strncpy (line, value.dptr, value.dsize);
  line[value.dsize] = '\0';
  datum_free(value);
  return line;
}

void
touch (db)
     GDBM_FILE db;
{
  int res;
  struct timeval t;
  static char buf[11];
  datum key;
  datum val;

  res = gettimeofday (&t, NULL);
  if (res == -1)
    return;
  sprintf (buf, "%010d", t.tv_sec);

  key.dptr = "YP_LAST_MODIFIED";
  key.dsize = 16;

  val.dptr = buf;
  val.dsize = 10;

  (void) gdbm_store (db, key, val, GDBM_REPLACE);
}

/* _pnr_ndbm_create
 */
void
_pnr_ndbm_create (d,  pnr, uname)
     int		d;		/* Descriptor */
     char *	pnr;		/* New entry to insert */
     char *      uname;
{
  int			res;
  datum		name_key;
  datum               pnr_key;
  datum		namevalue;
  datum               pnrvalue;

  info_data *info;
  info_data *tmp;

  name_key.dptr = uname;
  name_key.dsize = strlen (uname);
  pnr_key.dptr = pnr;
  pnr_key.dsize = strlen(pnr);

  
  if (!pnr_checkpnr(pnr)) {
    pw_errno = PW_EBADPNR;
    return;
  }
    
  /* Check if name already exists */

  namevalue = gdbm_fetch (_pw_dtab[d].module.ndbm.pnrbyname_db, name_key);
  if (namevalue.dptr != NULL)
    {
      /* If an exact match is found, don't treat this as an error */
      if (strncmp (namevalue.dptr, pnr, namevalue.dsize) != 0)
	pw_errno = PW_ENAMEEXISTS;
      datum_free(namevalue);
      return;
    }
  datum_free(namevalue);

  /* Store new entry in database */
    
  namevalue.dptr = pnr;
  namevalue.dsize = strlen (pnr);

    
    
  pnrvalue.dptr = _info_ndbm_getbypnr(d, pnr);
  if (pnrvalue.dptr == NULL) {
    if (pw_errno == PW_ENOTFOUND)
      {  /* not exist  */ 
	pw_errno = PW_EOK;
	info = info_make_empty(pnr);
      }
    else
      return;
  }
  else {
    /* exist */
    pnrvalue.dsize = strlen(pnrvalue.dptr);
    tmp = info = info_string_to_data(pnrvalue.dptr);
    datum_free(pnrvalue);
    if (info == NULL)
      {
	pw_errno = PW_EMEMORY;
	return;
      }
      
  }
    
  tmp = info_add_name(info,uname);
  if (tmp == NULL)
    {
      pw_errno = PW_EMEMORY;
      info_free_data(info);
      return;
    }
  info = tmp;

  pnrvalue.dptr = info_data_to_string(info);
  info_free_data(info);
  if (pnrvalue.dptr == NULL)
    {
      pw_errno = PW_EMEMORY;

      return;
    }
  pnrvalue.dsize = strlen(pnrvalue.dptr);

  res = gdbm_store (_pw_dtab[d].module.ndbm.pnrbyname_db, name_key, namevalue, GDBM_REPLACE);
  if (res < 0)
    {
      pw_errno = PW_EWRITE;
      datum_free(pnrvalue);
      return;
    }

  res = gdbm_store (_pw_dtab[d].module.ndbm.infobypnr_db, pnr_key, pnrvalue, GDBM_REPLACE);
  datum_free(pnrvalue);

  if (res < 0)
    {
      res = errno;
      (void) gdbm_delete (_pw_dtab[d].module.ndbm.pnrbyname_db, name_key);
      pw_errno = PW_EWRITE;
      errno = res;
      return;
    }
  touch (_pw_dtab[d].module.ndbm.infobypnr_db);
  touch (_pw_dtab[d].module.ndbm.pnrbyname_db);
}

/* _pnr_ndbm_delete
 */
void
_pnr_ndbm_delete (d, name)
     int d;       /* Descriptor */
     char * name;/* User name */
{
  int			res;
  datum		name_key;
  datum		pnr_key;
  datum		pnrvalue;
  char * pnr;
  char * strinfo;
  info_data *info;
  info_data *tmp;
  
  name_key.dptr = name;
  name_key.dsize = strlen (name);
  
  /* Check that old entry exists */
  if (!( gdbm_exists (_pw_dtab[d].module.ndbm.pnrbyname_db, name_key)))
    {
      /* Not treating this as an error makes operation idempotent */
      /* pw_errno = PW_ENOTFOUND; */
      return;
    }

  pnr = _pnr_ndbm_getbyname(d,name);
  pnr_key.dptr = pnr;
  pnr_key.dsize = strlen(pnr);

  
  /* Do the deletion */

  if ((strinfo = _info_ndbm_getbypnr(d,pnr)) == NULL) {
    free(pnr);
    if (pw_errno == PW_ENOTFOUND){
      (void) gdbm_delete (_pw_dtab[d].module.ndbm.pnrbyname_db, name_key);
      touch (_pw_dtab[d].module.ndbm.pnrbyname_db);
      pw_errno = PW_EOK;
    }
    return;
  }
  
  tmp = info = info_string_to_data(strinfo);
  free(strinfo);
  
  if (info == NULL)
    {
      pw_errno = PW_EMEMORY;
      free(pnr);
      return;
    }
  tmp = info_del_name(info,name);
  if (tmp == NULL)
    {
      pw_errno = PW_EMEMORY;
      info_free_data(info);
      free(pnr);
      return;
    }
  info = tmp;
  if (info_empty(info)) {
    info_free_data(info);
    (void) gdbm_delete (_pw_dtab[d].module.ndbm.pnrbyname_db, name_key);
    (void) gdbm_delete (_pw_dtab[d].module.ndbm.infobypnr_db, pnr_key);
    touch (_pw_dtab[d].module.ndbm.pnrbyname_db);
    touch (_pw_dtab[d].module.ndbm.infobypnr_db);
    free(pnr);
    return;
  } 
  pnrvalue.dptr = info_data_to_string(info);
  info_free_data(info);
  if (pnrvalue.dptr == NULL)
    {
      pw_errno = PW_EMEMORY;

      free(pnr);
      return;
    }
  pnrvalue.dsize = strlen(pnrvalue.dptr);
    
  (void) gdbm_delete (_pw_dtab[d].module.ndbm.pnrbyname_db, name_key);
  res = gdbm_store (_pw_dtab[d].module.ndbm.infobypnr_db, pnr_key, pnrvalue, GDBM_REPLACE);
  datum_free(pnrvalue);
  free(pnr);
  if (res < 0)
    {
      pw_errno = PW_EWRITE;

      // Borde skriva in gamla vrdet i databasen om det gr!!
	   return;
    }
  touch (_pw_dtab[d].module.ndbm.pnrbyname_db);
  touch (_pw_dtab[d].module.ndbm.infobypnr_db);
  return;
}

  
/* _comment_ndbm_change
 */
void
_comment_ndbm_change (d,  pnr, comment)
    int		d;		/* Descriptor */
    char *	pnr;		/* New entry to insert */
    char *      comment;
{
    int			res;
    datum               pnr_key;
    datum               value;

    info_data *info;
    info_data *tmp;
    char * info_str;
    
    pnr_key.dptr = pnr;
    pnr_key.dsize = strlen(pnr);
    
    /* Check if pnr already */
    
    info_str = _info_ndbm_getbypnr(d,pnr);
    if (info_str == NULL)
      {
	return;
      }
    tmp = info = info_string_to_data(info_str);
    free(info_str);
    if (info == NULL)
      {
	pw_errno = PW_EMEMORY;
	return;
      }
    
    tmp = info_change_comment(info,comment);
    if (tmp == NULL)
      {
	pw_errno = PW_EMEMORY;
	info_free_data(info);
	return;
      }
    info = tmp;
    value.dptr = info_data_to_string(info);
    if (value.dptr == NULL)
      {
	pw_errno = PW_EMEMORY;
	info_free_data(info);
	return;
      }
    value.dsize = strlen(value.dptr);
    info_free_data(info);
    res = gdbm_store (_pw_dtab[d].module.ndbm.infobypnr_db, pnr_key, value, GDBM_REPLACE);
    datum_free(value);
    if (res < 0){
      pw_errno = PW_EWRITE;
      // Borde skriva in det gamla vrdet!!
      return;
    }

    touch (_pw_dtab[d].module.ndbm.infobypnr_db);
}

/* _comment_ndbm_delete
 */
void
_comment_ndbm_delete (int d,  char *pnr)
{
    int			res;
    datum               pnr_key;
    datum               value;

    info_data *info;
    info_data *tmp;
    char * info_str;
    
    pnr_key.dptr = pnr;
    pnr_key.dsize = strlen(pnr);
    
    /* Check if pnr already */
    info_str = _info_ndbm_getbypnr(d,pnr);    
    if (info_str == NULL)
      {
      return;
    }
    tmp = info = info_string_to_data(info_str);
    free(info_str);
    if (info == NULL)
      {
	pw_errno = PW_EMEMORY;
	return;
      }
    
    tmp = info_delete_comment(info);
    if (tmp == NULL)
      {
	pw_errno = PW_EMEMORY;
	info_free_data(info);
	return;
      }
    info = tmp;
    value.dptr = info_data_to_string(info);
    if (value.dptr == NULL)
      {
	pw_errno = PW_EMEMORY;
	info_free_data(info);
	return;
      }
    value.dsize = strlen(value.dptr);
    info_free_data(info);
    
    res = gdbm_store (_pw_dtab[d].module.ndbm.infobypnr_db, pnr_key, value, GDBM_REPLACE);
    datum_free(value);
    if (res < 0)
    {
      pw_errno = PW_EWRITE;
 
      return;
    }

    touch (_pw_dtab[d].module.ndbm.infobypnr_db);
}

char *_info_ndbm_getbypnr(int d, char *pnr)
{
    datum	key;
    datum	value;
    char *	line;

    key.dptr = pnr;
    key.dsize = strlen (pnr);
    value = gdbm_fetch (_pw_dtab[d].module.ndbm.infobypnr_db, key);
    if (value.dptr == NULL)
    {
	pw_errno = PW_ENOTFOUND;
	return NULL;
    }

    line = malloc (value.dsize + 1);
    if (line == NULL) {
      pw_errno = PW_EMEMORY;
      datum_free(value);
      return NULL;
    }
    strncpy (line, value.dptr, value.dsize);
    datum_free(value);
    line[value.dsize] = '\0';
    return line;
}


char *_pnr_ndbm_getbyname(int d, char *name)
{
    datum	key;
    datum	value;
    char *	line;

    key.dptr = name;
    key.dsize = strlen (name);
    value = gdbm_fetch (_pw_dtab[d].module.ndbm.pnrbyname_db, key);
    if (value.dptr == NULL)
    {
	pw_errno = PW_ENOTFOUND;
	return NULL;
    }

    line = malloc (value.dsize + 1);
    if (line == NULL) {
      pw_errno = PW_EMEMORY;
      datum_free(value);
      return NULL;
    }

    strncpy (line, value.dptr, value.dsize);
    line[value.dsize] = '\0';
    datum_free(value);
    return line;
}

char *_names_ndbm_getbypnr(int d, char *pnr)
{
    char *	line;
    char *      names;
    info_data * info;

    line = _info_ndbm_getbypnr(d,pnr);
    if (line == NULL)
      return NULL;
    info = info_string_to_data(line);
    free(line);
    if (info == NULL)
      {
	pw_errno = PW_EMEMORY;
	return NULL;
      }
    

    names = info_get_names(info);
    info_free_data(info);
    if (names == NULL) 
      {
	pw_errno = PW_EMEMORY;
	return NULL;
      }
    
    return names;
}

char *_comment_ndbm_getbypnr(int d, char *pnr)
{
    char *	line;
    char *      comment;
    info_data * info;

    line = _info_ndbm_getbypnr(d,pnr);
    if (line == NULL)
      return NULL;
   
    info = info_string_to_data(line);
    free (line);
    if (info == NULL)
      {
	pw_errno = PW_EMEMORY;
	return NULL;
      }
    

    comment = info_get_comment(info);
    info_free_data(info);
    if (comment == NULL) 
      {
	pw_errno = PW_EMEMORY;
	return NULL;
      }
    
    return comment;
}



