#define PNRLEN  11
#define NAMELEN 16
#define COMMENTLEN 100


struct request
{
  int reqno;
  int	type;
  int id;
  union
  {
    struct { char new[PW_BUFLEN];	} 			create;
    struct { char old[PW_BUFLEN]; } 			delete;
    struct { char old[PW_BUFLEN]; char new[PW_BUFLEN]; } 	update;
    struct { int uid; } 				getpwuid;
    struct { char name[PW_BUFLEN]; } 			getpwnam;
    struct { int uid; } 				firstuid;
    struct { int uid; } 				nextuid;
    struct { char pnr[PNRLEN]; char name[NAMELEN]; }   pnrcreate;
    struct { char name[NAMELEN]; }   pnrdelete;
    struct { char pnr[PNRLEN]; char comment[COMMENTLEN]; }   commentchange;
    struct { char pnr[PNRLEN]; }   commentdelete;
    struct { char pnr[PNRLEN]; }   infogetbypnr;
    struct { char name[NAMELEN]; }   pnrgetbyname;
    struct { char pnr[PNRLEN]; }   namesgetbypnr;
    struct { char pnr[PNRLEN]; }   commentgetbypnr;
  } arg;
};

#define REQ_NULL	0
#define REQ_CREATE	1
#define REQ_DELETE	2
#define REQ_UPDATE	3
#define REQ_GETPWNAM	4
#define REQ_GETPWUID	5
#define REQ_FIRSTUID	6
#define REQ_NEXTUID	7
#define REQ_PNRCREATE   8
#define REQ_PNRDELETE   9
#define REQ_COMMENTCHANGE   10
#define REQ_COMMENTDELETE   11
#define REQ_INFOGETBYPNR   12
#define REQ_PNRGETBYNAME   13
#define REQ_NAMESGETBYPNR   14
#define REQ_COMMENTGETBYPNR   15

struct reply
{
    int reqno;
    int id;
    int	pw_errno;
    union
    {
	int krberr;
	int syntaxerr;
    } xerrno;
    int error;
    struct
    {
	char line[PW_BUFLEN];
	int  uid;
    } res;
};
