
/* string.c
 *
 */
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "bool.h"
#include "str.h"



/* duplen
 *
 * duplicate first 'len' characters from argument string
 */
char *
duplen (s, len)
    char *s;		/* The string to be (partially) copied */
    int  len;		/* The number of characters to copy */
{
    char *new;		/* The string to be returned */
    
    new = malloc ((unsigned) len + 1);
    if (new == (char *) 0)
	return (char *) 0;

    strncpy (new, s, len);
    new[len] = '\0';

    return new;
}

/* dupsub
 *
 * duplicate a substring of the argument string
 */
char *
dupsub (first, last)
    char *first;
    char *last;
{
    int  len;
    
    len = last - first + 1;
    return duplen (first, len);
}

/* stripline
 *
 * strip the trailing newline of a string - if any
 */
void
stripline (s)
    char *s;
{
    char *cp;
    
    cp = s;
    while (*cp)
	cp++;
    cp--;
    if (*cp == '\n')
	*cp = '\0';
}

/* commentline
 *
 * a line that starts with zero or more whites followed a '#' is a comment
 * lines that just contain whites also fall in this category
 */
bool
commentline (s)
    char *s;
{
    char *cp;

    cp = s;
    while (isspace (*cp))
	cp++;
    if (*cp == '\0' || *cp == '#')
	return TRUE;
    return FALSE;
}

void
lowcase (s)
    char *s;
{
    int i;
    int len;

    if (s != NULL)
    {
	len = strlen (s);
	for (i = 0; i < len; i++)
	    s[i] = tolower (s[i]);
    }
}

void
upcase (s)
    char *s;
{
    int i;
    int len;

    if (s != NULL)
    {
	len = strlen (s);
	for (i = 0; i < len; i++)
	    s[i] = toupper (s[i]);
    }
}

