#include <stdio.h>
#include <stdarg.h>
#include <syslog.h>

extern int pw_debug;
extern char *progname;

void
do_syslog (int prio, char *fmt, ...)
{
    va_list	args;

    va_start (args, fmt);
    if (pw_debug)
    {
	fprintf (stderr, "%s: warning: ", progname);
	(void) vfprintf (stderr, fmt, args);
	fputc ('\n', stderr);
    }
    else
	syslog (prio, fmt, args);
    va_end (args);
}

