
/* syntax.c
 *
 */

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <z/bool.h>
#include <z/error.h>
#include <z/itemize.h>
#include <z/date.h>
#include <z/str.h>
#include "pw.h"
#include "gecos.h"

static bool is_smallint ();
int pw_syntax_field (char *s, int level, int i);

int
pw_syntax (pwd, level)
    pw_data *pwd;
    int level;
{
    int i;
    int res;

    if (level < PW_SYNTAX_SLOPPY)
	return PW_SYNTAX_EOK;

    if (itemcount (pwd->pwv) != PW_NFIELDS)
	return PW_SYNTAX_ENFIELDS;

    for (i = 0; i < PW_NFIELDS; i++)
    {
	res = pw_syntax_field (pwd->pwv[i], level, i);
	if (res != PW_SYNTAX_EOK)
	    if (res != PW_SYNTAX_EHASPASSWD)
		return res;
	    else if (strcmp (pwd->pwv[PW_NAME], "root") != 0)
		return PW_SYNTAX_EHASPASSWD;
    }

    if (level < PW_SYNTAX_NORMAL)
	return PW_SYNTAX_EOK;

    if (pwd->gcv == NULL)
	return GC_SYNTAX_ENFIELDS;

    if (itemcount (pwd->gcv) != GC_NFIELDS)
	return GC_SYNTAX_ENFIELDS;

    for (i = 0; i < GC_NFIELDS; i++)
    {
	res = gc_syntax_field (pwd->gcv[i], level, i);
	if (res != PW_SYNTAX_EOK)
	    return res;
    }

    return PW_SYNTAX_EOK;
}


int
pw_syntax_field (char *s, int level, int i)
{
    if (level <= PW_SYNTAX_NONE)
	return PW_SYNTAX_EOK;

    if (index (s, ':') != NULL)
	return PW_SYNTAX_ECOLON;

    if (level < PW_SYNTAX_SLOPPY)
	return PW_SYNTAX_EOK;

    switch (i)
    {

    case PW_NAME:
	if (strlen (s) > 8)
	    return PW_SYNTAX_ENAMETOOLONG;
	if (strlen (s) == 0)
	    return PW_SYNTAX_ENONAME;
	/** Check valid chars **/
	return PW_SYNTAX_EOK;


    case PW_PASSWD:
	if (level < PW_SYNTAX_NORMAL)
	    return PW_SYNTAX_EOK;
	if (strlen (s) == 0)
	    return PW_SYNTAX_ENOPASSWD;
	if (level < PW_SYNTAX_PEDANTIC)
	    return PW_SYNTAX_EOK;
	if (strcmp (s, "*") != 0)
	    return PW_SYNTAX_EHASPASSWD;
	return PW_SYNTAX_EOK;

    case PW_UID:
	if (!is_smallint (s))
	    return PW_SYNTAX_EUID;
	return PW_SYNTAX_EOK;

    case PW_GID:
	if (!is_smallint (s))
	    return PW_SYNTAX_EGID;
	/** GID has a name **/
	return PW_SYNTAX_EOK;

    case PW_GECOS:
	return PW_SYNTAX_EOK;

    case PW_DIR:
	/** Home directory exists **/
	return PW_SYNTAX_EOK;

    case PW_SHELL:
	/** Shell in /etc/shells etc. **/
	/** Shell exists **/
	return PW_SYNTAX_EOK;

    default:
      // what to return? WE don't have dny PW_SYNTAX_NOT_OK?  
      //NFIELDS Sounds god
	return PW_SYNTAX_ENFIELDS;
    }
}


static bool
is_smallint (s)
    char *s;
{
    int i;
    int len;

    len = strlen (s);
    if (len > 5)
	return FALSE;
    for (i = 0; i < len; ++i)
	if (!isdigit (s[i]))
	    return FALSE;
    i = atoi (s);
    if (i > 65534)
	return FALSE;

    return TRUE;
}

bool
pw_check_shell (shell, shellfile)
    char *shell;
    char *shellfile;
{
    FILE *fp;
    static char buf[1024];

    ASSERT (shell != NULL);

    if (shellfile == NULL)
	shellfile = PW_SHELLFILE;

    fp = fopen (shellfile, "r");
    if (fp == NULL)
	return FALSE;
    
    while (fgets (buf, 1024, fp) != NULL)
    {
	stripline (buf);
	if (strcmp (buf, shell) == 0)
	    return TRUE;
    }

    return FALSE;
}

char *
pw_syntax_message (code)
    int code;
{
    switch (code)
    {

    case PW_SYNTAX_EOK:
	return "Syntax is OK";

    case PW_SYNTAX_ENFIELDS:
	return "Wrong number of fields";

    case PW_SYNTAX_ENAMETOOLONG:
	return "Too long login name";

    case PW_SYNTAX_EUID:
	return "Invalid uid";

    case PW_SYNTAX_EGID:
	return "Invalid gid";

    case PW_SYNTAX_ENONAME:
	return "Empty login name";

    case GC_SYNTAX_ENFIELDS:
	return "Wrong number of GECOS-fields";

    case GC_SYNTAX_ECREATIONDATE:
	return "Bad format for creationdate";

    case GC_SYNTAX_EEXPIRATIONDATE:
	return "Bad format for expirationdate";

    case PW_SYNTAX_EHASPASSWD:
	return "Password field is not '*'";

    case PW_SYNTAX_ENOPASSWD:
	return "Password field is empty";

    case PW_SYNTAX_ECOLON:
	return "Contains field separator ':'";

    case GC_SYNTAX_ECOMMA:
	return "Contains GECOS field separator ','";

    default:
	return "Unknown syntax error";
    }
}

