#include <z/bool.h>
#include <z/date.h>
#include <pw.h>
#include "params.h"
#include "user.h"

#define NULL 0

extern char *get_myname();
extern char *strdup ();

char *
build_pwline (u)
    user *u;
{
    static char buf[PW_BUFLEN];
    char *creationdate;
    char *expirationdate;

    creationdate = strdup (date2str (u->creationdate));
    expirationdate = strdup (date2str (u->expirationdate));

    sprintf (buf, "%s:*:%d:%d:%s,%s,%s,%s,%s,%s,%s,%s,%s,%s:%s:%s",
	     u->logname, u->uid, u->gid,
	     u->fullname, u->organization,
	     u->officephone, u->homephone,
	     u->comment,
	     creationdate, u->creator,
	     expirationdate,
	     u->mailforward,
	     u->adminfo,
	     u->home, u->shell);

    free (creationdate);
    free (expirationdate);

    return buf;
}

void
set_defaults (u)
    user *u;
{
    u->logname = NULL;
    u->passwd = NULL;
    u->uid = -1;
    u->uid_min = DEFAULT_UID_MIN;
    u->uid_max = DEFAULT_UID_MAX;
    u->gid = DEFAULT_GID;
    u->home = NULL;
    u->shell = DEFAULT_SHELL;

    u->fullname = NULL;
    u->organization = NULL;
    u->officephone = "";
    u->homephone = "";
    u->comment = "";
    u->creationdate = date2int (datetoday ());
    u->creator = get_myname();
    if (u->creator == NULL)
	my_abort ("get_myname kan inte hitta ditt anvndarnamn");
    else
	u->creator = strdup (u->creator);
    u->expirationdate = u->creationdate + 2 * 365;
    u->mailforward = "";
    u->adminfo = "";

    u->category = NULL;
    u->groups = NULL;
    u->mailaliases = NULL;
}
