#!/usr/local/bin/bash
#
# Kommer frn bg@nada.kth.se. Modifierat av patriks@e.kth.se fr Elektro.
# lagt till .dotfiles  /jf 970530
# Added -force /lha 1998-05-06
# Changed def quota
# Massa smfix:
#   - Lagade skiten s att den inte anvnder fel fs! (Satte PATH)
#   - Stavade rtt p elektrien, INTE ELEKTIEN!
#   - Sg till att skapa backupvolymen fre man monterar den s 
#     att man slipper massa felmeddelanden.
# /max 2000-01-25

PATH=/usr/afsws/bin:/usr/afsws/etc:/usr/bin:${PATH}

MAILBOXPATH=/usr/local/staff/admin/accounts/mailboxes

def_quota=50000
cell=e.kth.se
#domain=e..kth.se

function make.category() {
  if [ $# != 1 ];
  then
    echo "usage: $0 usercategory"
    exit 1
  fi
  
  cat=$1
  vol=home.$cat
  
  cd /afs/.$cell/home || exit 1
  
  vos create elektrien a $vol || exit 1
  fs mkm $cat $vol || exit 1
  chgrp daemon $cat || exit 1
  fs sa $cat system:anyuser rl || exit 1
  vos addsite elektrien a $vol || exit 1
  vos addsite basalt a $vol || exit 1
  vos addsite pyrit a $vol || exit 1
  vos rele $vol || exit 1
  vos rele home || exit 1
}

function usage () { echo $0 "server partition usercategory user uid [kthid] [-force]"; exit 1; }

force=1


if test $# = 6; then
  if test $6 = "-force"; then
    force=0
  else
    kthid=$6
  fi
fi

if test $# = 7; then
 if test $7 = "-force" ;
 then
   kthid=$6
   force=0
  else
    usage
  fi
fi

server=$1
partition=$2
category=$3
user=$4
id=$5

#id=`ypmatch $user passwd | awk -F: '{ print $3 }'`
#id=`hesinfo $user passwd | awk -F: '{print $3}'`

if test -z $kthid
then
  volume=home.$category.$user
else
  volume=home."$kthid"
fi

if [ ! -d /afs/.$cell/home/$category ];
then
  make.category $category
fi

echo creating user "$user=$id" at $server $partition home/$category/$user volume=$volume

#echo -n "Continue? (y/n): "
#read ans
#if [ "$ans" != "y" ];
#then
#  exit 1
#fi

if cd /afs/.$cell/home/$category;
then
  pts createuser $user $id
  vos create $server $partition $volume || test $force || exit 1
  fs mkm $user $volume || test $force || exit 1
  chown $id $user
  chgrp default $user
  fs sq $user -max $def_quota || test $force || exit 1
  pts cg $user":remote-users" -owner $user
  fs sa $user $user all system:anyuser l $user":remote-users" all || test $force || exit 1
  chmod  0755 $user

  mkdir $user/Private
  fs sa $user/Private system:anyuser none $user":remote-users" none
  chown $id $user/Private
  chgrp default $user/Private
  chmod  0700 $user/Private

  mkdir $user/Public
  fs sa $user/Public system:anyuser read
  chown $id $user/Public
  chgrp default $user/Public
  chmod  0755 $user/Public

  mkdir $user/public_html
  fs sa $user/public_html system:anyuser none
  fs sa $user/public_html service.http read
  chown $id $user/public_html
  chgrp default $user/public_html
  chmod  0755 $user/public_html

  ln -s /misc/info/lathundar/afs-lathund.txt $user/AFS.README
  chown $id $user/AFS.README
  chgrp default $user/AFS.README

# additions and changes start here /jf 970530
  mkdir $user/.dotfiles
  fs sa $user/.dotfiles system:anyuser read
  chown $id $user/.dotfiles
  chgrp default $user/.dotfiles
  chmod 0755 $user/.dotfiles

  cp -r /usr/athena/lib/prototype_user/.??* $user/
  cp -r /usr/athena/lib/prototype_user/* $user
  for i in $user/.dotfiles/.??*
  do
    j=`basename $i`
    ln -sf .dotfiles/$j $user/$j
  done
  chown -Rh $id.default $user
  chgrp -Rh default $user
# end of changes /jf 970530

  echo "Filling in home directory:"
  test -x /usr/local/staff/scripts/build-homedir &&
    /usr/local/staff/scripts/build-homedir --no-backup --uid $id $PWD/$user $user e.kth.se
  echo "-done"

  echo "Creating user in printer accounting database:"
  test -x /usr/local/staff/scripts/createperson &&
    /usr/local/staff/scripts/createperson --verbose $user
  echo "-done"

  vos backup $volume
  fs mkm $user/OldFiles "$volume".backup
  chown $id $user/OldFiles
  chgrp default $user/OldFiles

# echo "*** Don't forget to do a vos release home.$category ***"
  echo "Releasing home.${catagory}..."
#  vos release home.$category
  echo "Done."
else
  echo "no such category " $category
  exit 1
fi

echo "Adding ${user} to list of mailboxes to be created."
touch ${MAILBOXPATH}/${user}

exit 0
