
/* alloc
 *
 */

#include "bool.h"
#include "error.h"
#include <malloc.h>

extern char *malloc ();

static void (*errhandler) () = NULL;


char *
alloc (int amount) {
    char *new;

    new = malloc (amount);

    if (new != NULL)
	return new;

    if (errhandler != NULL)
	(*errhandler) ();

    my_abort ("Memory allocation fails");
}

void
alloc_set_errhandler (void (*func)()) {
    errhandler = func;
}
