
/* basename.c
 *
 */

#include "bool.h"
#include "str.h"
#include "basename.h"

extern char *malloc ();
extern char *strdup ();
extern char *rindex ();

#define Last_slash(s)	(rindex (s, '/'))


/* basename
 *
 * Works as basename(1)
 */
char *
basename (path, suffix)
    char *path;		/* Path name to extract 'basename' from */
    char *suffix;	/* Optional suffix to strip */
{
    char *filepos;	/* File portion of path - directory stripped */
    int  filelen;	/* Length of file portion of path */
    int  suffixlen;	/* Length of 'suffix' above */
    char *suffixpos;    /* Start position of suffix (IF ANY) */

    filepos = Last_slash (path);
    if (filepos == 0)
	filepos = path;
    else
	filepos++;

    if (suffix == 0)
	return filepos;
    
    filelen = strlen (filepos);
    suffixlen = strlen (suffix);
    if (suffixlen > filelen)
	return strdup (filepos);

    suffixpos = filepos + (filelen - suffixlen);

    if (strcmp (suffixpos, suffix) != 0)
	return strdup (filepos);
    else
	return dupsub (filepos, suffixpos - 1);
}


char *
dirname (path)
    char *path;		/* Path name to extract 'dirname' from */
{
    char *slash;	/* Position of last slash in path name */

    slash = Last_slash (path);
    if (slash == 0)
	return strdup (".");
    if (slash == path)
	return strdup ("/");
    return dupsub (path, slash - 1);
}


char *
samedir (path, file)
    char *path;		/* Path name to extract 'dirname' from */
    char *file;		/* File name to append to 'dirname' of path */
{
    char *slash;	/* Position of last slash in path name */
    int  dirlen;	/* Length of 'dirname' including trailing slash */
    char *new;		/* Result string */
    

    slash = Last_slash (path);
    if (slash == 0)
	return strdup (file);
    dirlen = (slash - path + 1);
    new = malloc ((unsigned) dirlen + strlen (file) + 1);
    if (new == 0)
	return 0;
    strncpy (new, path, dirlen);
    strcpy (new + dirlen, file);
    return new;
}

#ifdef TESTMAIN

#include <stdio.h>

main (argc, argv)
    int argc;
    char *argv[];
{
    if (argc != 3)
    {
	fprintf (stderr, "usage: basename path suffix\n");
	exit (1);
    }
    printf ("basename: %s\n", basename (argv[1], argv[2]));
    printf ("dirname: %s\n", dirname (argv[1]));
    printf ("samedir: %s\n", samedir (argv[1], argv[2]));
    exit (0);
}

#endif
