
/* error.c
 *
 */

#include <stdio.h>
#include <stdarg.h>
#include <syslog.h>
#include <errno.h>
#include "error.h"

extern char *progname;
void (*abort_hook) ();

void
my_warning (char *fmt, ...) {
    va_list args;

    va_start (args, fmt);
    fmt = va_arg (args, char *);
    fprintf (stderr, "%s: warning: ", progname);
    (void) vfprintf (stderr, fmt, args);
    fputc ('\n', stderr);
    va_end (args);
}

void
my_error (char *fmt, ...) {
    va_list args;

    va_start (args, fmt);
    fmt = va_arg (args, char *);
    fprintf (stderr, "%s: ", progname);
    (void) vfprintf (stderr, fmt, args);
    fputc ('\n', stderr);
    va_end (args);
}

void
my_abort (char *fmt, ...) {
    va_list args;

    va_start (args, fmt);
    fmt = va_arg (args, char *);
    fprintf (stderr, "%s: ", progname);
    (void) vfprintf (stderr, fmt, args);
    fputc ('\n', stderr);
    if (abort_hook != NULL)
	(*abort_hook) ();
    exit (1);
    va_end (args);
}

void
my_syswarn (char *fmt, ...) {
    va_list args;

    va_start (args, fmt);
    fmt = va_arg (args, char *);
    fprintf (stderr, "%s: warning: ", progname);
    (void) vfprintf (stderr, fmt, args);
    fprintf(stderr, ": %s\n", strerror(errno));
    va_end (args);
}

void
my_syserr (char *fmt, ...) {
    va_list args;

    va_start (args, fmt);
    fmt = va_arg (args, char *);
    fprintf (stderr, "%s: ", progname);
    (void) vfprintf (stderr, fmt, args);
    fprintf(stderr, ": %s\n", strerror(errno));
    va_end (args);
}

void
my_sysabort (char *fmt, ...) {
    va_list args;

    va_start (args, fmt);
    fmt = va_arg (args, char *);
    fprintf (stderr, "%s: ", progname);
    (void) vfprintf (stderr, fmt, args);
    fprintf(stderr, ": %s\n", strerror(errno));
    if (abort_hook != NULL)
	(*abort_hook) ();
    exit (1);
    va_end (args);
}



