
/* itemize.c
 *
 * split a string into parts.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "error.h"
#include "itemize.h"

#define max(a,b)	(a > b ? a : b)



/* itemize
 *
 */
char **
itemize (buf, separators)
    char *buf;
    char *separators;
{
    char *safe_buf;
    char ** itemv;
    char **safe_itemv;
    int i;

    safe_buf = strdup (buf);
    if (safe_buf == NULL)
	return NULL;

    itemv = _itemize (safe_buf, separators);
    
    for (i = 0; itemv[i] != NULL; i++)
	;
    
    safe_itemv = (char **) malloc (((i + 1) * sizeof (char *)));
    if (safe_itemv == NULL)
	return NULL;
    
    for (i = 0; itemv[i] != NULL; i++)
	safe_itemv[i] = itemv[i];
    safe_itemv[i] = NULL;
    
    return safe_itemv;
}


/* _itemize
 *
 */
char **
_itemize (buf, separators)
    char *buf;
    char *separators;
{
    static char		*itemv[ITEMV_SIZE];
    int			itemc;
    register char	*cp;

    ASSERT (buf != NULL);
    
    itemc = 0;
    cp = buf;
    while (*cp)
    {
	itemv [itemc++] = cp;
	while (*cp && index (separators, *cp) == NULL)
	    cp++;
	if (*cp)
	{
	    *cp++ = '\0';
	    if (*cp == '\0')
		itemv[itemc++] = cp;
	}
    }
    itemv [itemc] = NULL;

    return itemv;
}

/* nitemize
 *
 * Nitemize is like itemize, except that it always returns an n-long
 * item-vector.
 */
char **
nitemize (buf, separators, n)
    char *buf;
    char *separators;
    int n;
{
    char *safe_buf;
    char ** itemv;
    char **safe_itemv;
    int i;

    safe_buf = strdup (buf);
    if (safe_buf == NULL)
	return NULL;

    itemv = _itemize (safe_buf, separators);
    
    for (i = 0; itemv[i] != NULL; i++)
	;
    
    safe_itemv = (char **) malloc (((max (n, i) + 1) * sizeof (char *)));
    if (safe_itemv == NULL)
	return NULL;
    
    for (i = 0; i < n && itemv[i] != NULL; i++)
	safe_itemv[i] = itemv[i];
    while (i < n)
	safe_itemv[i++] = NULL;
    safe_itemv[n] = NULL;
    
    return safe_itemv;
}

void
itemfree (itemv)
    char **itemv;
{
    free (itemv[0]);
    free ((char *) itemv);
}


char *
deitemize (v, c)
    char **v;
    char c;
{
    int i;
    int len;
    char *s;
    char *src, *dst;

    len = 0;
    for (i = 0; v[i] != NULL; i++)
	len += (strlen (v[i]) + 1);
    
    s = malloc (len);
    if (s == NULL)
	return NULL;
    
    dst = s;
    for (i = 0; v[i] != NULL; i++)
    {
        src = v[i];
        while ((*dst++ = *src++))
            ;
        *(dst - 1) = c;
    }
    *--dst = '\0';

    return s;
}

int
itemcount (v)
    char **v;
{
    int i;

    for (i = 0; v[i] != NULL; i++)
	;

    return i;
}
