/* $Id: gpw.c,v 1.14 2004/01/29 10:28:23 mattiasa Exp $ */

#include <stdio.h>
#include <readline/readline.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <pw.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <z/itemize.h>

#define BUFSIZE 1024

char * progname;
static char *printercmd;

static int
getprinter()
{
    char prompt[BUFSIZE];
    char *printer;
    char *line;
    int len;
    if(!printercmd) {
        printer = getenv("PRINTER");

        snprintf(prompt, sizeof(prompt), "Where do you want the printout? [%s] ", printer);
        line = readline(prompt);

        if(line && line[0] != '\0') {
            printer = line;
        }

	len=strlen(printer)+13;

	printercmd = malloc(len);
	if(!printercmd) {
	    fprintf(stderr, "malloc: %s", strerror(errno));
	    exit(1);
	}

        snprintf(printercmd, len, "lpp -4 -i -P%s", printer);

	printercmd[len] = '\0';

        if(line)
            free(line);
    }

    return printercmd ? 1 : 0;
}


int main (int argc, char ** argv) {

    int chpass_fd;
    char * username = NULL;
    char * old;
    char * yesno;
    char * passwd;
    char ** items;
    char ** gechos;
    char * fullname;

    int studieanm = 0;

    progname = argv[0];
    chpass_fd = pw_args (&argc, &argv);

    if (argc > 1) {
	username = argv[1];
    }

    if (username == NULL) {
	username = readline("Skriv in anvndarnamnet vars lsenord skall ndras: ");
    }

    old = pw_getpwnam (chpass_fd, username);

    if (old == NULL) {
	printf("Username %s doesn't seem to exist. Aborting.\n", username);
	pw_abort();
    }

    items = itemize(old, ":");

    if(items != NULL) {
	 gechos = itemize(items[4], ",");
	 if(gechos != NULL) {
	      fullname = gechos[0];
	 } else {
	      fullname = NULL;
	 }
    } else {
	 fullname = NULL;
    }

    printf("\n");
    printf("-----------------------------\n");
    printf("Namn\t\t: %s\n", fullname);
    printf("Anvndarnamn\t: %s\n", username);
    printf("-----------------------------\n");

    yesno = readline("Vill du generera ett nytt lsenord [JA/nej]: ");

    if(checkyesno(yesno)) {

	pw_kadm_usr_init (30);

	passwd = pw_mkpasswd(username);

	pw_kadm_change_password (username, passwd);

	if (pw_errno != PW_EOK) {
	    bzero(passwd, strlen(passwd));
	    pw_abort();
	}

	printf("Det nya lsenordet r: %s\n", passwd);
	free(yesno);
	yesno = readline("Vill du ha en utskrift [JA/nej]: ");
	if(checkyesno(yesno)) {
            FILE *pip;
            int i ;
	    char motd[] = "OBS --> Det r skillnad p stora och sm bokstver i lsenordet. <---\n" 
		"Du ndrar lsen med \"passwd\" i UNIX.\n"
		"Byt INTE tillbaka till ditt fregende lsenord.\n"
		"Vlj ett lsenord som bestr utav minst tta tecken.\n"
		"Anvnd begynnelsebokstverna i ngon nonsensmening\n"
		"Anvnd siffror, skiljetecken och blandat STORA oCh sm bokstver\n";

	    if(!getprinter())
		return 0;

            pip = popen(printercmd, "w");
            if (pip != NULL) {

                fprintf(pip, "%s\n\n", motd);   /* 8 rows */

                fprintf(pip, "Password: %s\r\n          ( ", passwd);

		for (i=0; i < strlen(passwd) ; i++) {
		    fprintf(pip, "%s ", pw_convchartoword(passwd[i]));
		}

		fprintf(pip,")\r\n");

                for (i = 0 ; i < 40 ; i++)
                    fprintf(pip, "\r\n");
                
                fclose(pip);
	    }
	}

    }

    return 0;
}

int checkyesno(char * yesno) {
    return (yesno[0] == 'j' || yesno[0] == 'J' ||
	    yesno[0] == 'y' || yesno[0] == 'Y' || yesno[0] == '\0');
}
