/*
 *  CINAG - Chess Is Not A Game
 * 
 *  Copyright (c) 2001, 2002 PAYEMENT Arnaud
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef BITBOARD_H
#define BITBOARD_H

#include "data.h"

#define BITBOARD_FULL 18446744073709551615ULL

inline bool BB_GetValue(bitboard_t board,pos_t pos){bitboard_t mask=1;mask<<=pos;board=board&mask;if(board!=0) return true;else return false;}
inline void BB_SetValueTrue(bitboard_t &board,pos_t pos){bitboard_t mask=1;mask<<=pos;board=board|mask;}
inline void BB_SetValueFalse(bitboard_t &board,pos_t pos){bitboard_t mask=1;mask<<=pos;board=board&~mask;}

void BB_Print(bitboard_t board);

#endif
