/*
 *  CINAG - Chess Is Not A Game
 * 
 *  Copyright (c) 2001, 2002 PAYEMENT Arnaud
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef DATA_H
#define DATA_H

#undef true
#define true 1
#undef false 
#define false 0

#define PAWN   0
#define KNIGHT 1
#define BISHOP 2
#define ROOK   3
#define QUEEN  4
#define KING   5

#define PAWN_VALUE    100
#define ROOK_VALUE    550
#define KNIGHT_VALUE  500
#define BISHOP_VALUE  450
#define QUEEN_VALUE  1200
#define MATE_VALUE   1000000

#define WHITE 0
#define BLACK 1
#define MATCH_NUL 2

#define NOMOVE 99
#define NOPOS  99

#define WBROCK 100
#define WSROCK 101
#define BBROCK 102
#define BSROCK 103

#define MAX_NB_RESULT 200

#ifdef WIN32
	typedef __int64 int64;
#else
	typedef unsigned long long int int64;
#endif

typedef int64 bitboard_t;
typedef signed long int slint_t;
typedef char pos_t;

inline bool Parity(int64 num){if(((num>>1)<<1)==num) return true;else return false;}
inline bool FirstBit(int64 num){if(((num>>1)<<1)==num) return false;else return true;}

inline int PS_GetX(pos_t pos){return pos-((int)((int)pos>>3)<<3)+1;}
inline int PS_GetY(pos_t pos){return ((int)pos>>3)+1;}

typedef struct {
  pos_t start;
  pos_t stop;
} move_t;

typedef struct {
  public:
  bitboard_t data[2][6];
  bitboard_t color[2];
} board_t;


#endif

