/*
 *  CINAG - Chess Is Not A Game
 * 
 *  Copyright (c) 2001, 2002 PAYEMENT Arnaud
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "debug.h"
#include "db.h"
#include "board.h"
#include "hashcode.h"
#include "ini_file.h"

#define MAX_NB_DBRESULT 1000
fpos_t pos;
bool pos_set;
bool disactivate;

typedef struct {
    hashcode_t code1;
    hashcode_t code2;
    char start;
    char stop;
    char result;
} cdata_t;

unsigned long int nbmove;
move_t cmove[MAX_NB_DBRESULT];

void DB_Init()
{
    pos_set = false;
    disactivate = false;
}

int  DB_FindMove(board_t *board,char result)
{
    if (disactivate == true) return 0;
    ini_file_t conf;
    char *buff;
    FILE *db;
    hashcode_t code1 = HC_CreateHashCode(board,hashcode1);
    hashcode_t code2 = HC_CreateHashCode(board,hashcode2);
    cdata_t cdata;
    fpos_t swap;
    
    nbmove = 0;
    conf.read("conf.ini");
    
    buff = conf.getcharvalue("DATABASE","enable");
    if (!strcmp("true",buff)) {
	buff = conf.getcharvalue("DATABASE","path");
	db = fopen(buff,"rb");
	if (db == NULL) {
	    error(cannot open database file);
	}
	if (pos_set == true) fsetpos(db,&pos);
	for (;!feof(db);) {
	    fgetpos(db,&swap);
	    if (fread(&cdata,sizeof(cdata_t),1,db)==0) break;
	    if ((cdata.code1 == code1)&&(cdata.code2 == code2)&&(cdata.result == result)) {
		if (nbmove == 0) {
		    pos = swap;
		    pos_set = true;
		}
		nbmove++;
		cmove[nbmove-1].start = cdata.start;
		cmove[nbmove-1].stop = cdata.stop;
		if (nbmove >= MAX_NB_DBRESULT) break;
	    }
	}
	fclose(db);
	if (nbmove == 0) disactivate = true;
	return nbmove;
    } return 0;
}

move_t DB_GetMove(int64 num)
{
    return cmove[num];
}


int sboard[8][8]={{ 4, 2, 3, 5, 6, 3, 2, 4},
                  { 1, 1, 1, 1, 1, 1, 1, 1},
                  { 0, 0, 0, 0, 0, 0, 0, 0},
                  { 0, 0, 0, 0, 0, 0, 0, 0},
                  { 0, 0, 0, 0, 0, 0, 0, 0},
                  { 0, 0, 0, 0, 0, 0, 0, 0},
                  {-1,-1,-1,-1,-1,-1,-1,-1},
                  {-4,-2,-3,-5,-6,-3,-2,-4}};

void DB_AddGame(move_t *move,int nbmove,int result)
{
    FILE *db;
    board_t *board;
    cdata_t cdata;
    
    db = fopen("./db/chess.db","a");
    if (db == NULL) error(cannot open file ./db/chess.db);
    
    board = BO_Convert(sboard);
    for(int I=0;I<nbmove;I++) {
	BO_Move(board,move[I]);
	cdata.code1 = HC_CreateHashCode(board,hashcode1);
	cdata.code2 = HC_CreateHashCode(board,hashcode2);
	cdata.start = move[I].start;
	cdata.stop = move[I].stop;
	cdata.result = result;
	fwrite(&cdata,sizeof(cdata_t),1,db);
    }
    delete board;
    fclose(db);
}
