/*
 *  CINAG - Chess Is Not A Game
 * 
 *  Copyright (c) 2001, 2002 PAYEMENT Arnaud
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "hashcode.h"

hashcode_t HC_CreateHashCode(board_t *data,bool type)
{
    hashcode_t hashcode;
    if (type == hashcode1) {
	hashcode  = data->data[0][0];// >> 20;
	hashcode ^= data->data[0][1];// >> 31;
	hashcode ^= data->data[0][2];// >> 22;
	hashcode ^= data->data[0][3];// >> 31;
	hashcode ^= data->data[0][4];// >> 15;
	hashcode ^= data->data[0][5];// >> 27;
	hashcode ^= data->data[1][0];// >> 13;
	hashcode ^= data->data[1][1];// >> 22;
	hashcode ^= data->data[1][2];// >> 31;
	hashcode ^= data->data[1][3];// >> 17;
	hashcode ^= data->data[1][4];// >> 28;
	hashcode ^= data->data[1][5];// >> 34;
    } else {
	hashcode  = data->data[0][0] << 1;
	hashcode ^= data->data[0][1] >> 1;
	hashcode ^= data->data[0][2] << 2;
	hashcode ^= data->data[0][3] >> 2;
	hashcode ^= data->data[0][4] << 1;
	hashcode ^= data->data[0][5] >> 1;
	hashcode ^= data->data[1][0] << 2;
	hashcode ^= data->data[1][1] >> 2;
	hashcode ^= data->data[1][2] << 1;
	hashcode ^= data->data[1][3] >> 1;
	hashcode ^= data->data[1][4] << 2;
	hashcode ^= data->data[1][5] >> 2;
    }
    return hashcode;
}
