/*
 *  CINAG - Chess Is Not A Game
 * 
 *  Copyright (c) 2001, 2002 PAYEMENT Arnaud
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "transposition.h"
#include "debug.h"
#include "ini_file.h"

transpo_t *black_tt;
transpo_t *white_tt;
unsigned long int size;
unsigned long int deca;

unsigned long int pow2(int n)
{
    if (n<=0) return 1;
    else return 2*pow2(n-1);
}

void TP_Init ()
{
    unsigned int I;
    ini_file_t conf;
    conf.read("conf.ini");
    deca = conf.getintvalue("TRANSPOSITION","size");
    size = pow2(deca);
    black_tt = new transpo_t [size];
    white_tt = new transpo_t [size];
    for(I=0;I<size;I++)
    {
	black_tt[I].depth = -127;
	black_tt[I].code2 = 0;
	black_tt[I].type = hash_exact;
	black_tt[I].value = 0;
	white_tt[I].depth = -127;
	white_tt[I].code2 = 0;
	white_tt[I].type = hash_exact;
	white_tt[I].value = 0;
    }
}


void TP_AddResult (hashcode_t code1,transpo_t trans,bool color)
{
    transpo_t prev;
    if (color == WHITE) prev = white_tt[(size-1)&(code1)]; 
    else prev = black_tt[(size-1)&(code1)];   
    if (((prev.type != hash_exact)&&(trans.type == hash_exact))||(trans.depth >= prev.depth)) {
	if (color == WHITE) white_tt[(size-1)&(code1)] = trans; 
	else black_tt[(size-1)&(code1)] = trans;  
    } 
}

transpo_t TP_FindResult (hashcode_t code1, bool color)
{
    transpo_t trans;
    unsigned int index = (unsigned int)((size-1)&(code1));;
    if (color == BLACK) trans = black_tt[index];
    if (color == WHITE) trans = white_tt[index];
    return trans; 
}

void
TP_Free ()
{
    delete black_tt;
    delete white_tt;
}

void
TP_Exit ()
{
    delete black_tt;
    delete white_tt;
}
