#include <stdio.h>
#include <iostream.h>
#include <time.h>
#include "../../src/data.h"
#include "../../src/bitboard.h"
#include "../../src/genmove.h"
#include "../../src/board.h"

#define NUM 1  // 1,2,3,4,5,6,7,8,9,0
#define LE1 2  // A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z
#define LE2 3  // a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z
#define POI 4  // '.'
#define NEG 6  // '-'
#define PLU 7  // '+'
#define EQU 8  // '='
#define SLA 9  // '/'
#define DIE 10 // '#'
#define UNK 0

typedef struct {
   bitboard_t data[2][6];
   bitboard_t color[2];
   char start;
   char stop;
   char result;
} data_t;

int iboard[8][8]={{ 4, 2, 3, 5, 6, 3, 2, 4},
                  { 1, 1, 1, 1, 1, 1, 1, 1},
                  { 0, 0, 0, 0, 0, 0, 0, 0},
                  { 0, 0, 0, 0, 0, 0, 0, 0},
                  { 0, 0, 0, 0, 0, 0, 0, 0},
                  { 0, 0, 0, 0, 0, 0, 0, 0},
                  {-1,-1,-1,-1,-1,-1,-1,-1},
                  {-4,-2,-3,-5,-6,-3,-2,-4}};

int read = 0;
int nbgame=0;
bool verbosity=false;
board_t *board;
bool color=WHITE;
bool error=false;

int nbmove = 0;
board_t *bboard;
move_t  *bmove;

FILE *file;
FILE *dst;

void finish()
{
 fclose(file);
 fclose(dst);
 exit(0);
}

void print(move_t bmove)
{
 cout << (char)(PS_GetX(bmove.start)+96) << (int)PS_GetY(bmove.start);
 cout << (char)(PS_GetX(bmove.stop)+96) << (int)PS_GetY(bmove.stop) << "\n";
}

void write(char result)
{
  data_t data;
  for (int I=0;I<nbmove;I++) {
    data.data[0][0] = bboard[I].data[0][0];
    data.data[0][1] = bboard[I].data[0][1];
    data.data[0][2] = bboard[I].data[0][2];
    data.data[0][3] = bboard[I].data[0][3];
    data.data[0][4] = bboard[I].data[0][4];
    data.data[0][5] = bboard[I].data[0][5];
    data.data[1][0] = bboard[I].data[1][0];
    data.data[1][1] = bboard[I].data[1][1];
    data.data[1][2] = bboard[I].data[1][2];
    data.data[1][3] = bboard[I].data[1][3];
    data.data[1][4] = bboard[I].data[1][4];
    data.data[1][5] = bboard[I].data[1][5];
    data.color[0] = bboard[I].color[0];
    data.color[1] = bboard[I].color[1];
    data.start = bmove[I].start;
    data.stop = bmove[I].stop;
    data.result = result;
    fwrite(&data,sizeof(data_t),1,dst);
  }
}

board_t copy(board_t *a)
{
  board_t b;
  b.data[0][0] = a->data[0][0];
  b.data[0][1] = a->data[0][1];
  b.data[0][2] = a->data[0][2];
  b.data[0][3] = a->data[0][3];
  b.data[0][4] = a->data[0][4];
  b.data[0][5] = a->data[0][5];
  b.data[1][0] = a->data[1][0];
  b.data[1][1] = a->data[1][1];
  b.data[1][2] = a->data[1][2];
  b.data[1][3] = a->data[1][3];
  b.data[1][4] = a->data[1][4];
  b.data[1][5] = a->data[1][5];
  b.color[0] = a->color[0];
  b.color[1] = a->color[1];
  return b;
}

board_t copy(board_t a)
{
  board_t b;
  b.data[0][0] = a.data[0][0];
  b.data[0][1] = a.data[0][1];
  b.data[0][2] = a.data[0][2];
  b.data[0][3] = a.data[0][3];
  b.data[0][4] = a.data[0][4];
  b.data[0][5] = a.data[0][5];
  b.data[1][0] = a.data[1][0];
  b.data[1][1] = a.data[1][1];
  b.data[1][2] = a.data[1][2];
  b.data[1][3] = a.data[1][3];
  b.data[1][4] = a.data[1][4];
  b.data[1][5] = a.data[1][5];
  b.color[0] = a.color[0];
  b.color[1] = a.color[1];
  return b;
}

move_t copy(move_t a)
{
  move_t b;
  b.start = a.start;
  b.stop = a.stop;
  return b;
}

void addGame(int win)
{
  board_t tboard;
  if ((error==false)&&(win!=2)) {
     write(win);
     cout << win;
     nbgame++;
  }
  board = BO_Convert(iboard);
  color = WHITE;
  nbmove = 0;
  error = false;
  delete bboard;
  delete bmove;
  bboard = new board_t[0];
  bmove  = new move_t[0];
}

void addMove(int num,int piece,int sx,int sy,int dx,int dy)
{
 move_t pos[MAX_NB_RESULT];
 int  nb;
 board_t *tboard;
 move_t *tmove;

 nb = GN_Generate(board,color,pos);
 for(int I=0;I<nb;I++) {
  if ((dx<99)||(dx>104)) {
    if (!BB_GetValue(board->data[color][piece],pos[I].start)) continue;
    if ((sx!=-1)&&(PS_GetX(pos[I].start)!=sx)) continue;
    if ((sy!=-1)&&(PS_GetY(pos[I].start)!=sy)) continue;
    if ((dx!=-1)&&(PS_GetX(pos[I].stop)!=dx)) continue;
    if ((dy!=-1)&&(PS_GetY(pos[I].stop)!=dy)) continue;
  } else {
    if (dx != pos[I].start) continue;
  }
  tboard = new board_t[nbmove];
  tmove = new move_t[nbmove];
  for(int J=0;J<nbmove;J++) {
          tboard[J] = copy(bboard[J]);
          tmove[J] = copy(bmove[J]);
  }
  nbmove++;
  delete bboard;
  delete bmove;
  bboard = new board_t[nbmove];
  bmove = new move_t[nbmove];
  for(int J=0;J<nbmove-1;J++) {
          bboard[J] = copy(tboard[J]);
          bmove[J] = copy(tmove[J]);
  }
  delete tboard;
  delete tmove;
  bboard[nbmove-1] = copy(board);
  bmove[nbmove-1] = copy(pos[I]);

  // print(pos[I]);

  BO_Move(board,pos[I]);
  color = !color;
  return;
 }
 error = true;
}


int getType(char buffer)
{
 if ( ( buffer > 47 )&&( buffer < 58  ) ) return NUM;
 if ( ( buffer > 64 )&&( buffer < 91  ) ) return LE1;
 if ( ( buffer > 96 )&&( buffer < 123 ) ) return LE2;
 if ( buffer == '.' ) return POI;
 if ( buffer == '-' ) return NEG;
 if ( buffer == '+' ) return PLU;
 if ( buffer == '=' ) return EQU;
 if ( buffer == '/' ) return SLA;
 if ( buffer == '#' ) return DIE;
 return UNK;
}

char readfile(FILE *file)
{
   char buffer;
   for(;!feof(file);){
      fread(&buffer,1,1,file);
      if (verbosity) cout << buffer; 
      if ( buffer == '[') read++;
      if ( buffer == ']'){
         read--;
         continue;
      }
      if ( buffer == '{') read++;
      if ( buffer == '}'){
         read--;
         continue;
      }
      if ( read != 0 ) continue;
      if ( buffer == ' ' ) continue;
      if ( buffer == '\n') continue;
      if ( buffer == 13) continue;
      if ( buffer == '\t') continue;
      if ( buffer == '+') continue;
      if ( buffer == 'x') continue;
      if ( buffer == '='){
         fread(&buffer,1,1,file);
         fread(&buffer,1,1,file);
         continue;
      }
      if ( buffer == '#') continue;
      return buffer;
   }
   cout << "\nnumber of game added: " << nbgame << "\n";
   finish();
}

void revertToStableState(FILE *file)
{
  char buffer = ' ';
  cout << "revert to stable state\n";
  for(;!feof(file);){
    fread(&buffer,1,1,file);
    if (buffer == ']') break; // we suppose that is stable state
  }
  board = BO_Convert(iboard);
  color = WHITE;
  nbmove = 0;
  error = false;
  delete bboard;
  delete bmove;
  bboard = new board_t[0];
  bmove  = new move_t[0];
}

int main(int argc, char *argv[])
{
  char buffer;
  bool read = true;
  int type;
  int num_add = 0;

  // store data
  int  num;
  int  piece;
  int  sx,sy;
  int  dx,dy;
  int  win;

  if (argc < 3) {
     cout << "\n\tsyntax : " << argv[0] << " input output\n\n";
     cout << "this command is used to decrypte PGN file and to put them in a\n";
     cout << "computer-readable form.\n";
     exit(0);
  }
 
  if ((argc > 3)&&(argv[3][0] == '-')&&(argv[3][1] == 'v')) verbosity = true; 

  board = BO_Convert(iboard);
  // initialisation
  GN_Init();
  file = fopen(argv[1],"r");
  if (file==NULL) {
     cout << "cannot open : " << argv[1] << " for reading\n";
     exit(0);
  }
  dst = fopen(argv[2],"ab");
  if (dst==NULL) {
     cout << "cannot open : " << argv[2] << " for writing\n";
     exit(0);
  }

  // analyse
  cout << "Convert\n";
  buffer = readfile(file);
  type = getType(buffer);

  for(;!feof(file);) {
         if (type == UNK) {cout << "\nerror (UNK) : " << buffer << "\n";revertToStableState(file);buffer = readfile(file);type = getType(buffer);continue;};
         if (type == NUM) {
            num = buffer-48;
            for(;;){
              buffer = readfile(file);
              type = getType(buffer);
              if (type == NUM) num = num*10+buffer-48;
              else break;
            }
            if (type == NEG) {
                win = 1-num;
                buffer = readfile(file);
                addGame(win);
                buffer = readfile(file);
                type = getType(buffer);
                continue;
            } else if (buffer == '/') {
                win = 2;
                buffer = readfile(file);
                buffer = readfile(file);
                buffer = readfile(file);
                buffer = readfile(file);
                buffer = readfile(file);
                nbmove --;
                addGame(win);
                buffer = readfile(file);
                type = getType(buffer);
                continue;
            } else if (type != POI) {cout << "\nerror (POI) : " << buffer << "\n";revertToStableState(file);buffer = readfile(file);type = getType(buffer);continue;};
            buffer = readfile(file);
            type = getType(buffer);

            // white move
            piece = PAWN;
            sx = -1;sy = -1;
            dx = -1;dy = -1;
            if (type == LE1) {
               if (buffer == 78) piece = KNIGHT;
               else if (buffer == 81) piece = QUEEN;
               else if (buffer == 75) piece = KING;
               else if (buffer == 82) piece = ROOK;
               else if (buffer == 66) piece = BISHOP;
               else piece  = buffer;
               buffer = readfile(file);
               type = getType(buffer);
            }
            if (type == NEG) {
                piece = KING;
                buffer = readfile(file);
                if (buffer != 'O')  {cout << "\nerror (O) : " << buffer << "\n";revertToStableState(file);buffer = readfile(file);type = getType(buffer);continue;};
                buffer = readfile(file);
                type = getType(buffer);
                if (buffer!='-')  {
                   sx = WSROCK;
                   sy = WSROCK;
                   dx = WSROCK;
                   dy = WSROCK;
                } else {
                   buffer = readfile(file);
                   type = getType(buffer);
                   if (buffer != 'O') {cout << "\nerror (O) : " << buffer << "\n";revertToStableState(file);buffer = readfile(file);type = getType(buffer);continue;};
                   sx = WBROCK;
                   sy = WBROCK;
                   dx = WBROCK;
                   dy = WBROCK;
                   buffer = readfile(file);
                   type = getType(buffer);
                }
            } else {
                if (type == NUM) {
                   sy = buffer-48;
                   buffer = readfile(file);
                   type = getType(buffer);
                }
                if (type == LE2) {
                   dx = buffer-96;
                } else {cout << "\nerror (LE2) : " << buffer << "\n";revertToStableState(file);buffer = readfile(file);type = getType(buffer);continue;};
                buffer = readfile(file);
                type = getType(buffer);
                if (type == LE2) {
                   sx = dx;
                   dx = buffer-96;
                   buffer = readfile(file);
                   type = getType(buffer);
                }
                if (type == NUM) {
                   dy = buffer-48;
                } else {cout << "\nerror (NUM) : " << buffer << "\n";revertToStableState(file);buffer = readfile(file);type = getType(buffer);continue;};
                buffer = readfile(file);
                type = getType(buffer);

                if ((type == LE1)&&(piece==PAWN)&&(dy==8)) {        // pion qui se change en reine
                   buffer = readfile(file);
                   type = getType(buffer);
                }
            }

            num_add++;
            addMove(num,piece,sx,sy,dx,dy);


            // black move
            piece = PAWN;
            sx = -1;sy = -1;
            dx = -1;dy = -1;
            if (type == NUM) {
                win = 1-(buffer-48);
                buffer = readfile(file);  // '-'
                if (buffer == '/') {
                   win = 2;
                   buffer = readfile(file);  // '2'
                   buffer = readfile(file);  // '-'
                   buffer = readfile(file);  // '1'
                   buffer = readfile(file);  // '/'
                }
                addGame(win);
                buffer = readfile(file);  // 'N'
                type = getType(buffer);
                continue;
            }
            if (type == LE1) {
               if (buffer == 78) piece = KNIGHT;
               else if (buffer == 81) piece = QUEEN;
               else if (buffer == 75) piece = KING;
               else if (buffer == 66) piece = BISHOP;
               else if (buffer == 82) piece = ROOK;
               else piece  = buffer;
               buffer = readfile(file);
               type = getType(buffer);
            }
            if (type == NEG) {
                piece = KING;
                buffer = readfile(file);
                if (buffer != 'O')  {cout << "\nerror (O) : " << buffer << "\n";revertToStableState(file);buffer = readfile(file);type = getType(buffer);continue;};
                buffer = readfile(file);
                type = getType(buffer);
                if (buffer!='-')  {
                   sx = BSROCK;
                   sy = BSROCK;
                   dx = BSROCK;
                   dy = BSROCK;
                } else {
                   buffer = readfile(file);
                   type = getType(buffer);
                   if (buffer != 'O') {cout << "\nerror (O) : " << buffer << "\n";revertToStableState(file);buffer = readfile(file);type = getType(buffer);continue;};
                   sx = BBROCK;
                   sy = BBROCK;
                   dx = BBROCK;
                   dy = BBROCK;
                   buffer = readfile(file);
                   type = getType(buffer);
                }
            } else {
                if (type == NUM) {
                   sy = buffer-48;
                   buffer = readfile(file);
                   type = getType(buffer);
                }
                if (type == LE2) {
                   dx = buffer-96;
                } else {cout << "\nerror (LE2) : " << buffer << "\n";revertToStableState(file);buffer = readfile(file);type = getType(buffer);continue;};
                buffer = readfile(file);
                type = getType(buffer);
                if (type == LE2) {
                   sx = dx;
                   dx = buffer-96;
                   buffer = readfile(file);
                   type = getType(buffer);
                }
                if (type == NUM) {
                   dy = buffer-48;
                } else {cout << "\nerror (NUM) : " << buffer << "\n";revertToStableState(file);buffer = readfile(file);type = getType(buffer);continue;};
                buffer = readfile(file);
                type = getType(buffer);
                if ((type == LE1)&&(piece==PAWN)&&(dy==1)) {        // pion qui se change en reine
                   buffer = readfile(file);
                   type = getType(buffer);
                }
             }

             addMove(num,piece,sx,sy,dx,dy);

         } else {cout << "\nerror (GLOBAL NUM) : " << buffer << "\n";revertToStableState(file);buffer = readfile(file);type = getType(buffer);continue;};
  }

  finish();

  return 0;
}
