/*
 *  CINAG - Chess Is Not A Game
 * 
 *  Copyright (c) 2001, 2002 PAYEMENT Arnaud
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "data.h"
#include "genmove.h"
#include "board.h"
#include "analyse.h"

#define MAX(a, b)  (((a) > (b)) ? (a) : (b))
#define MIN(a, b)  (((a) < (b)) ? (a) : (b))

bool CH_Check(board_t *board,bool color)
{
    board_t *buffer;
    int I;
    slint_t value;
    move_t move[MAX_NB_RESULT];
    GN_Generate(board,!color,move);
    for(I=0;I<MAX_NB_RESULT;I++)
    {
	buffer = BO_Copy(board);
	BO_Move(buffer,move[I]);
	if (color == BLACK) value = MAX(value,AN_Analyse(board));
	if (color == WHITE) value = MIN(value,AN_Analyse(board));
	delete buffer;
    }
    if ((color == WHITE)&&(value == -MATE_VALUE)) return true;
    if ((color == BLACK)&&(value == MATE_VALUE)) return true;
    return false;
}
