/*
 *  CINAG - Chess Is Not A Game
 * 
 *  Copyright (c) 2001, 2002 PAYEMENT Arnaud
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef INTERFACE_H
#define INTERFACE_H

#ifdef WIN32
#include <windows.h>
#endif

#include "gui.h"
#include "data.h"
#include "object3d.h"
#include "texture.h"

class interface_t{
public:
  interface_t() : rotaV(180),rotaH(60),isDialog(false),GameNbMove(0),boardTexture(false),pieceTexture(false),reflection(false),renderMode(GL_RENDER) {}
  void          start();
  void          loop(bool color);
  move_t        getmove(board_t *board,bool color);
  const         interface_t& operator<< (char *buffer);
  const         interface_t& operator<< (int buffer);
  const         interface_t& operator<< (double buffer);
  const         interface_t& operator<< (float buffer);
  const         interface_t& operator<< (long int buffer);
  const         interface_t& operator<< (move_t buffer);
  const         interface_t& operator<< (board_t *buffer);
  void          updateEvent();
  void          clearprogress();
  void          end();
private:
  void          AddToGame(move_t move);
  float         rotaV,rotaH;
  bool          isDialog;
  int           GameNbMove;
  bool          boardTexture;
  bool          pieceTexture;
  bool          reflection;
  int	        renderMode;
  board_t       *board;
  move_t        *game;
  move_t        sdlMove;
  float         clearRed,clearGreen,clearBlue;
  bool          userColor;
  window_t      window;
  object3d_t    pawn,knight,bishop,queen,king,rook,dialog;
  texture_t     blackText,whiteText,blackBoardText,whiteBoardText,whiteWin,blackWin;
};

#endif
