
import Blender210
import math
import string

class mdlexport:
    def __init__(self, filename):
        self.file    = open(filename, "w")
        self.scene   = None
        self.display = None

    def export(self, scene):
        print "exporting ..."
        self.scene = scene
        self.display = Blender210.getDisplaySettings()
        self.writeFrame(self.display.currentFrame)
        self.writeEnd()

    def writeEnd(self):
        self.file.close()
        print "... finished"

    def writeFrame(self, frame):
        Blender210.setCurrentFrame(frame)
        self.writeWorld()

    def writeObject(self, name):
        if Blender210.isMesh(name):
            meshobj = Blender210.getObject(name)
            mesh    = Blender210.getMesh(meshobj.data)
            
            self.file.write("7 %s %s %s\n" % (0.8, 0.8, 0.8))
            index = 0
            for face in mesh.faces:
                if meshobj.materials and meshobj.materials[face[5]]:
                    material = Blender210.getMaterial(meshobj.materials[face[5]])
                    self.file.write("7 %s %s %s\n" %
                                    (material.R, material.G, material.B))
                if face[3]:
                    # quad
                    for i in xrange(4):
                    	self.file.write("5 %s %s %s\n" %
                                       (mesh.normals[face[i]][0],
                                        mesh.normals[face[i]][1],
                                        mesh.normals[face[i]][2]))
                        self.file.write("4 %s %s %s\n" %
                                       (mesh.vertices[face[i]][0],
                                        mesh.vertices[face[i]][1],
                                        mesh.vertices[face[i]][2]))
		        if mesh.texture:
			        self.file.write("6 %s %s\n" %
				        (mesh.texcoords[index][0],
	         			1.0 - mesh.texcoords[index][1]))
			if mesh.colors:
				self.file.write("7 %s %s %s\n" %
					(mesh.colors[face[i]][0],
					mesh.colors[face[i]][1],
					mesh.colors[face[i]][2]))
                else:
                    # triangle
                    for i in xrange(3):
                        self.file.write("5 %s %s %s\n" %
                                       (mesh.normals[face[i]][0],
                                        mesh.normals[face[i]][1],
                                        mesh.normals[face[i]][2]))
                        self.file.write("3 %s %s %s\n" %
                                       (mesh.vertices[face[i]][0],
                                        mesh.vertices[face[i]][1],
                                        mesh.vertices[face[i]][2]))
                        if mesh.colors:
                            	self.file.write("7 %s %s %s\n" %
                                        (mesh.colors[face[i]][0],
                                        mesh.colors[face[i]][1],
                                        mesh.colors[face[i]][2]))
			if mesh.texture:
                        	self.file.write("6 %s %s\n" %
                                       (mesh.texcoords[index][i][0],
                                        1.0 - mesh.texcoords[index][i][1]))
                index = index + 1
        else:
            print "Sorry can export meshes only ..."

    def writeWorld(self):
        for name in self.scene.objects:
            if not Blender210.isCamera(name) and not Blender210.isLamp(name):
                self.writeObject(name)



mdlexport = mdlexport("file.mdl")
scene = Blender210.getCurrentScene()
mdlexport.export(scene)
