#include <stdio.h>
#include <iostream.h>
#include <stdlib.h>
#include "../../src/data.h"
#include "../../src/hashcode.h"

// cdb data
typedef struct data_t {
   bitboard_t data[2][6];
   bitboard_t color[2];
   char start;
   char stop;
   char result;
} data_t;

typedef struct {
    hashcode_t code1;
    hashcode_t code2;
    char start;
    char stop;
    char result;
} cdata_t;

int main(int argc,char *argv[])
{
 FILE *src;
 FILE *dst;
 data_t data;
 board_t *board = new board_t;
 int I=0;

 // buffer
 cdata_t cdata;

 if (argc < 2) {
     cout << "All input data will be compressed and inserted into chess.db and index.db.\n";
     exit(0);
 }

 src = fopen(argv[1],"rb");
 if (src==NULL) {
   cout << "cannot open : " << argv[1] << " for reading\n";
   exit(0);
 }
 dst = fopen("chess.db","ab");
 if (dst==NULL) {
   cout << "cannot open : chess.db for writing\n";
   exit(0);
 }

 cout << "work in progress...\n";

 for (;!feof(src);) {
     if (fread(&data,sizeof(data_t),1,src)==0) break;
     for(I=0;I<6;I++) board->data[0][I] = data.data[0][I];
     for(I=0;I<6;I++) board->data[1][I] = data.data[1][I];
     board->color[0] = data.color[0];
     board->color[1] = data.color[1];
     cdata.code1 = HC_CreateHashCode(board,hashcode1);
     cdata.code2 = HC_CreateHashCode(board,hashcode2);
     cdata.start  = data.start;
     cdata.stop   = data.stop;
     cdata.result = data.result;
     fwrite(&cdata,sizeof(cdata_t),1,dst);
 }
 printf("\n");

 fclose(src);
 fclose(dst);
}

