/*
 *  CINAG - Chess Is Not A Game
 * 
 *  Copyright (c) 2001, 2002 PAYEMENT Arnaud
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "analyse.h"
#include "genmove.h"

slint_t AN_Analyse(board_t *board)
{
 signed long int nb=0;
 bitboard_t mask=1;
 if (board->data[0][5]==0) return -MATE_VALUE;
 if (board->data[1][5]==0) return  MATE_VALUE;
 if (board->data[0][4]!=0) nb += QUEEN_VALUE;
 if (board->data[1][4]!=0) nb -= QUEEN_VALUE;
 for(int I=0;I<64;I++){
         if ((board->data[0][0]&mask)!=0) nb += PAWN_VALUE + PS_GetY(I);
         if ((board->data[1][0]&mask)!=0) nb -= PAWN_VALUE + (8 - PS_GetY(I));
         if ((board->data[0][1]&mask)!=0) nb += KNIGHT_VALUE;
         if ((board->data[1][1]&mask)!=0) nb -= KNIGHT_VALUE;
         if ((board->data[0][2]&mask)!=0) nb += BISHOP_VALUE;
         if ((board->data[1][2]&mask)!=0) nb -= BISHOP_VALUE;
         if ((board->data[0][3]&mask)!=0) nb += ROOK_VALUE;
         if ((board->data[1][3]&mask)!=0) nb -= ROOK_VALUE;
         mask<<=1;
 }
return nb;
}


slint_t AN_BasicAnalyse(board_t *board)
{
 if (board->data[0][5]==0) return -MATE_VALUE;
 else if (board->data[1][5]==0) return  MATE_VALUE;
 return 0;
}

