/*
 *  CINAG - Chess Is Not A Game
 * 
 *  Copyright (c) 2001, 2002 PAYEMENT Arnaud
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "killer.h"
#include "debug.h"

typedef struct killer_t
{
    int value;
    move_t *move;
    killer_t *next;
} killer_t;

int *killer_num;
killer_t **root;
int nblevel;
int off;

void KL_Init(int lev,int q)
{
    int I;
    off = q;
    nblevel = lev+off+1;
    killer_num = new int[nblevel];
    root = new killer_t* [nblevel];
    for(I=0;I<nblevel;I++)
    {
	killer_num[I] = 0;
	root[I] = NULL;
    }
}

void KL_SetKiller(move_t move,int l)
{
    killer_t *killer,*new_killer;
    int swapvalue;
    move_t *swapmove;
    int level = l + off;

    if (level < 0) return;
    if (level>=nblevel)
	warning(level strange); 

    if (killer_num[level] == 0)
    {
	root[level] = new killer_t;
	root[level]->move = new move_t;
	root[level]->move->start = move.start;
	root[level]->move->stop = move.stop;
	root[level]->value = 0;
	root[level]->next = NULL;
	killer_num[level]++;
    } else {
	new_killer = root[level];
	killer = NULL;
	for(;;)
	    if ((new_killer->move->start == move.start)&&(new_killer->move->stop == move.stop))
	    {
		new_killer->value++;
		if ((killer != NULL)&&(new_killer->value >= killer->value)) {
		    swapvalue = killer->value;
		    swapmove = killer->move;
		    killer->value = new_killer->value;
		    killer->move = new_killer->move;
		    new_killer->value = swapvalue;
		    new_killer->move = swapmove;
		}
		break;
	    } else {
		if (new_killer->next != NULL) {
		    killer = new_killer;
		    new_killer = new_killer->next;		
		} else {
		    killer = new_killer;
		    killer->next = new killer_t;
		    new_killer = killer->next;
		    new_killer->move = new move_t;
		    new_killer->value = 1;
		    new_killer->move->start = move.start;
		    new_killer->move->stop = move.stop;
		    new_killer->next = NULL;
		    killer_num[level]++;
		    break;
		}
	    }
    }
}

move_t KL_GetKiller(int l,int num)
{
    int I;
    killer_t *killer;
    move_t error;
    error.start = NOMOVE;
    error.stop = NOMOVE;
    int level = l + off;

    if (level < 0) return error;;
    if (level>=nblevel) 
	warning(level strange); 

    killer = root[level];
    if ((num<0)||(num>=killer_num[level])) return error;
    for(I=0;I<num;I++)
    {
	killer = killer->next;
    }
    return *killer->move;
}

void KL_Free()
{
    int I;
    killer_t *killer;
    killer_t *new_killer;

    for(I=0;I<nblevel;I++) {
	killer = root[I];
	new_killer = NULL;	    
	if (killer_num[I] == 0) return;
	for(;;)
	{
	    new_killer = killer->next;
	    delete killer->move;
	    delete killer;
	    killer = new_killer;
	    if (killer == NULL) break;
	}
	killer_num = 0;
    }
}
