/*
 *  CINAG - Chess Is Not A Game
 * 
 *  Copyright (c) 2001, 2002 PAYEMENT Arnaud
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "object3d.h"
#include "debug.h"
#include <stdio.h>
#include <iostream.h>

bool object3d_t::load(char *filename)
{
  FILE *file;
  int code;
  int mode = 0;
  char oct = ' ';
  float coord1,coord2,coord3;

  if ((file = fopen(filename,"r"))==NULL)
    {
      warning(Could not load object3d);
      return false;
    }
  id = glGenLists(1);
  glNewList(id,GL_COMPILE);
  for (;!feof(file);)
    {
      fscanf(file,"%d",&code);
      if (code == 0)
	for(;oct!='\n';)
	  fread(&oct,1,1,file);
      else if (code == 1) {
	if ((mode != code)&&(mode != 0)) {
	  glEnd();
	  mode = 0;
	}
	if (mode == 0) {
	  glBegin(GL_POINTS);
	  mode = code;
	}
	fscanf(file,"%f %f %f",&coord1,&coord2,&coord3);
	glVertex3f(coord1,coord2,coord3);
      } else if (code == 2) {
	if ((mode != code)&&(mode != 0)) {
	  glEnd();
	  mode = 0;
	}
	if (mode == 0) {
	  glBegin(GL_LINES);
	  mode = code;
	}
	fscanf(file,"%f %f %f",&coord1,&coord2,&coord3);
	glVertex3f(coord1,coord2,coord3);
      } else if (code == 3) {
	if ((mode != code)&&(mode != 0)) {
	  glEnd();
	  mode = 0;
	}
	if (mode == 0) {
	  glBegin(GL_TRIANGLES);
	  mode = code;
	}
	fscanf(file,"%f %f %f",&coord1,&coord2,&coord3);
	glVertex3f(coord1,coord2,coord3);
      } else if (code == 4) {
	if ((mode != code)&&(mode != 0)) {
	  glEnd();
	  mode = 0;
	}
	if (mode == 0){
	  glBegin(GL_QUADS);
	  mode = code;
	}
	fscanf(file,"%f %f %f",&coord1,&coord2,&coord3);
	glVertex3f(coord1,coord2,coord3);
      } else if (code == 5) {
	fscanf(file,"%f %f %f",&coord1,&coord2,&coord3);
	glNormal3f(coord1,coord2,coord3);
      } else if (code == 6) {
	fscanf(file,"%f %f",&coord1,&coord2);
	glTexCoord2f(coord1,coord2);
	cout << "glTexCoord(" << coord1 << "," << coord2 << ");\n";
      } else if (code == 7) {
	fscanf(file,"%f %f %f",&coord1,&coord2,&coord3);
	glColor3f(coord1,coord2,coord3);
      } else warning(unknown 3d data code);
    }
  glEnd();
  glEndList();
  fclose(file);
  return true;
}

void object3d_t::draw()
{
  glCallList(id);
}
