#include <stdlib.h>
#include <stdio.h>
#include <dirent.h>
#include <string.h>
#include <sys/stat.h>

#define DEBUG

int checkext(char *filename,char *ext)
{
    for(int i=0;i<strlen(ext);i++)
	if (filename[strlen(filename)-i] != ext[strlen(ext)-i]) return 0;
    return 1;
}

static int isdir (char *path) {
  struct stat attribut;  
  stat (path, &attribut);
  return S_ISDIR (attribut.st_mode);
}

int process_unzip(char *str)
{
    char strup[200];
    char command[50];
    struct dirent *dptr;
    DIR *dirp;

    fprintf(stderr,"%s\n",str);
    if((dirp=opendir(str))==NULL)
    {
	printf("Error opening %s\n",str);
	return 0;
    }    
    while(dptr=readdir(dirp))
    {
	strcpy(strup,str);
	strcat(strup,"/");
	strcat(strup,dptr->d_name);
	strcat(strup,"\0");
	if (dptr->d_name[0] != '.') {
	    if (isdir(strup)) {
		process_unzip(strup);
	    } else {
		if (checkext(dptr->d_name,"zip")||checkext(dptr->d_name,"ZIP")) {
		    sprintf(command,"unzip %s",strup);
#ifdef DEBUG
		    printf("%s\n",command);
#endif
		    system(command);
		}
	    }
	}
    }
    closedir(dirp);
    return 0;   
}

int process_move(char *str)
{
    char strup[200];
    char command[50];
    struct dirent *dptr;
    DIR *dirp;

    fprintf(stderr,"%s\n",str);
    if((dirp=opendir(str))==NULL)
    {
	printf("Error opening %s\n",str);
	return 0;
    }    
    while(dptr=readdir(dirp))
    {
	strcpy(strup,str);
	strcat(strup,"/");
	strcat(strup,dptr->d_name);
	strcat(strup,"\0");
	if (dptr->d_name[0] != '.') {
	    if (isdir(strup)) {
		process_move(strup);
	    } else {
		if (checkext(dptr->d_name,"pgn")||checkext(dptr->d_name,"PGN")) {
		    sprintf(command,"cp %s %s",strup,"./data");
#ifdef DEBUG
		    printf("%s\n",command);
#endif
		    system(command);
		}
	    }
	}
    }
    closedir(dirp);
    return 0;   
}

int process_insert(char *str)
{
    char strup[200];
    char command[50];
    struct dirent *dptr;
    DIR *dirp;

    fprintf(stderr,"%s\n",str);
    if((dirp=opendir(str))==NULL)
    {
	printf("Error opening %s\n",str);
	return 0;
    }    
    while(dptr=readdir(dirp))
    {
	strcpy(strup,str);
	strcat(strup,"/");
	strcat(strup,dptr->d_name);
	strcat(strup,"\0");
	if (dptr->d_name[0] != '.') {
	    if (isdir(strup)) {
		process_insert(strup);
	    } else {
		if (checkext(dptr->d_name,"pgn")||checkext(dptr->d_name,"PGN")) {
		    sprintf(command,"convert %s %s",strup,"cdb");
#ifdef DEBUG
		    printf("%s\n",command);
#endif
		    system(command);
		    sprintf(command,"insert cdb",strup);
#ifdef DEBUG
		    printf("%s\n",command);
#endif
		    system(command);
		    sprintf(command,"rm cdb");
#ifdef DEBUG
		    printf("%s\n",command);
#endif
		    system(command);
		}
	    }
	}
    }
    closedir(dirp);
    return 0;   
}

int main(int argc,char *argv[])
{
    system("mkdir ./data");
    if ((argc >0)&&(argv[1] == "-insert"))
    {
	printf("insert\n");
//	process_insert(".\0");
    } else 
    {
	process_unzip(".\0");
	process_move(".\0");
	process_insert("./data\0");
    }
    return 0;
}
