/*
 *  CINAG - Chess Is Not A Game
 * 
 *  Copyright (c) 2001, 2002 PAYEMENT Arnaud
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <iostream.h>

#include "board.h"
#include "bitboard.h"


void BO_Move(board_t *board,move_t move)
{
    bool color = WHITE;
    char bb,bb2;
    move_t tmp;
    if (move.start == WSROCK){
	tmp.start = 7;
	tmp.stop  = 5;
	BO_Move(board,tmp);
	tmp.start = 4;
	tmp.stop  = 6;
	BO_Move(board,tmp);
    }
    if (move.start == WBROCK){
	tmp.start = 0;
	tmp.stop  = 3;
	BO_Move(board,tmp);
	tmp.start = 4;
	tmp.stop  = 2;
	BO_Move(board,tmp);
    }
    if (move.start == BSROCK){
	tmp.start = 63;
	tmp.stop  = 61;
	BO_Move(board,tmp);
	tmp.start = 60;
	tmp.stop  = 62;
	BO_Move(board,tmp);
    }
    if (move.start == BBROCK){
	tmp.start = 56;
	tmp.stop  = 59;
	BO_Move(board,tmp);
	tmp.start = 60;
	tmp.stop  = 58;
	BO_Move(board,tmp);
    }
    if (BB_GetValue(board->color[0],move.start)==1) color = WHITE;
    else if (BB_GetValue(board->color[1],move.start)==1) color = BLACK;
    else return;
    for(bb=0;bb<6;bb++) if (BB_GetValue(board->data[color][bb],move.start)==1) break;
    BB_SetValueFalse(board->color[color]    ,move.start);
    BB_SetValueFalse(board->data[color][bb] ,move.start);
    if (BB_GetValue(board->color[1-color],move.stop)==1){
	for(bb2=0;bb2<6;bb2++) BB_SetValueFalse(board->data[1-color][bb2],move.stop);
	BB_SetValueFalse(board->color[1-color],move.stop);
    }
    BB_SetValueTrue(board->color[color]   ,move.stop);
    BB_SetValueTrue(board->data[color][bb],move.stop);
    if ((PS_GetY(move.stop)==8)&&(bb==PAWN)){
	BB_SetValueFalse(board->data[WHITE][PAWN],move.stop);
	BB_SetValueTrue(board->data[WHITE][QUEEN],move.stop);
    }
    if ((PS_GetY(move.stop)==1)&&(bb==PAWN)){
	BB_SetValueFalse(board->data[BLACK][PAWN],move.stop);
	BB_SetValueTrue(board->data[BLACK][QUEEN],move.stop);
    }
}

board_t *BO_Convert(int board[8][8])
{
    int I,J;
    board_t *bboard;
    bboard = new board_t;
    
    for(I=0;I<2;I++)
	for(J=0;J<6;J++)
	    bboard->data[I][J]=0;
    bboard->color[0]=0;
    bboard->color[1]=0;
    for(I=0;I<8;I++)
	for(J=0;J<8;J++)
	    if (board[I][J]>0){
		BB_SetValueTrue(bboard->color[0],I*8+J);
		BB_SetValueTrue(bboard->data[0][board[I][J]-1],I*8+J);
	    }
	    else if (board[I][J]<0){
		BB_SetValueTrue(bboard->color[1],I*8+J);
		BB_SetValueTrue(bboard->data[1][-board[I][J]-1],I*8+J);
	    }
    return bboard;
}

void BO_Convert(board_t *board,int sortie[8][8])
{
    int piece;
    for(int coord=0;coord<64;coord++)
	if (BB_GetValue(board->color[0],coord)==1) {
	    for(piece=0;piece<6;piece++)
		if (BB_GetValue(board->data[0][piece],coord)==1) break;
	    sortie[PS_GetY(coord)-1][PS_GetX(coord)-1] = piece+1;
	} else if (BB_GetValue(board->color[1],coord)==1){
	    for(piece=0;piece<6;piece++)
		if (BB_GetValue(board->data[1][piece],coord)==1) break;
	    sortie[PS_GetY(coord)-1][PS_GetX(coord)-1] = -piece-1;
	} else sortie[PS_GetY(coord)-1][PS_GetX(coord)-1] = 0;
}

board_t *BO_Copy(board_t *board)
{
    board_t *newBoard;
    newBoard = new board_t;
    newBoard->data[0][0] = board->data[0][0];
    newBoard->data[0][1] = board->data[0][1];
    newBoard->data[0][2] = board->data[0][2];
    newBoard->data[0][3] = board->data[0][3];
    newBoard->data[0][4] = board->data[0][4];
    newBoard->data[0][5] = board->data[0][5];
    newBoard->data[1][0] = board->data[1][0];
    newBoard->data[1][1] = board->data[1][1];
    newBoard->data[1][2] = board->data[1][2];
    newBoard->data[1][3] = board->data[1][3];
    newBoard->data[1][4] = board->data[1][4];
    newBoard->data[1][5] = board->data[1][5];
    newBoard->color[0] = board->color[0];
    newBoard->color[1] = board->color[1];
    return newBoard;
}
