/*
 *  CINAG - Chess Is Not A Game
 * 
 *  Copyright (c) 2001, 2002 PAYEMENT Arnaud
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <iostream.h>
#include "genmove.h"
#include "bitboard.h"


struct GN_Data GN_Table[7][64][64];


void GN_Print(struct GN_Data tab[64])
{
 for(int J=7;J>=0;J--){
  for(int I=J*8;I<J*8+8;I++){
   if ((tab[I].nextpos!=99)||(tab[I].nextdir!=99)) cout << "|" << tab[I].nextpos << " " << tab[I].nextdir << tab[I].condition << "\t";
   else cout << "|      \t";
  }
  cout << "\n";
 }
}

void GN_Init()
{
  int previous,futur,start;
  for(int p=0;p<7;p++)
     for(int s=0;s<64;s++)
         for(int d=0;d<64;d++){
            GN_Table[p][s][d].nextpos = NOMOVE;
            GN_Table[p][s][d].nextdir = NOMOVE;
            GN_Table[p][s][d].condition = 0;
         }
  for(int piece=0;piece<7;piece++){
     switch (piece)
     {
     case PAWN://*************** WHITE PAWN *********************
     for(start=0;start<64;start++){
             if (PS_GetY(start)==2){
               GN_Table[piece][start][start].nextpos = start+8;
               GN_Table[piece][start][start+8].nextdir = -1;
               GN_Table[piece][start][start+8].condition = 2;
               GN_Table[piece][start][start+16].condition = 2;
               GN_Table[piece][start][start+8].nextpos = start+16;
               GN_Table[piece][start][start+16].nextdir = -1;
               if ((PS_GetX(start)>1)&&(PS_GetX(start)<8)){
                  GN_Table[piece][start][start+8].nextdir = start+7;
                  GN_Table[piece][start][start+16].nextdir = start+7;
                  GN_Table[piece][start][start+7].nextdir = start+9;
                  GN_Table[piece][start][start+7].condition = 1;
                  GN_Table[piece][start][start+9].condition = 1;
                  continue;
               }
               if (PS_GetX(start)>1){
                  GN_Table[piece][start][start+8].nextdir = start+7;
                  GN_Table[piece][start][start+16].nextdir = start+7;
                  GN_Table[piece][start][start+7].condition = 1;
                  continue;
               }
               if (PS_GetX(start)<8){
                  GN_Table[piece][start][start+8].nextdir = start+9;
                  GN_Table[piece][start][start+16].nextdir = start+9;
                  GN_Table[piece][start][start+9].condition = 1;
                  continue;
               }
             }
             if (PS_GetY(start)<8){
               GN_Table[piece][start][start+8].condition = 2;
               GN_Table[piece][start][start].nextpos = start+8;
               GN_Table[piece][start][start+8].nextdir = -1;
               if ((PS_GetX(start)>1)&&(PS_GetX(start)<8)){
                  GN_Table[piece][start][start+8].nextdir = start+7;
                  GN_Table[piece][start][start+7].nextdir = start+9;
                  GN_Table[piece][start][start+7].condition = 1;
                  GN_Table[piece][start][start+9].condition = 1;
                  continue;
               }
               if (PS_GetX(start)>1){
                  GN_Table[piece][start][start+8].nextdir = start+7;
                  GN_Table[piece][start][start+7].condition = 1;
                  continue;
               }
               if (PS_GetX(start)<8){
                  GN_Table[piece][start][start+8].nextdir = start+9;
                  GN_Table[piece][start][start+9].condition = 1;
                  continue;
               }
             }
     }
     break;//*************** BLACK PAWN *********************
     case PAWN+6:
     for(start=0;start<64;start++){
             if (PS_GetY(start)==7){
               GN_Table[piece][start][start-8].condition = 2;
               GN_Table[piece][start][start-16].condition = 2;
               GN_Table[piece][start][start].nextpos = start-8;
               GN_Table[piece][start][start-8].nextdir = -1;
               GN_Table[piece][start][start-8].nextpos = start-16;
               GN_Table[piece][start][start-16].nextdir = -1;
               if ((PS_GetX(start)>1)&&(PS_GetX(start)<8)){
                  GN_Table[piece][start][start-8].nextdir = start-7;
                  GN_Table[piece][start][start-16].nextdir = start-7;
                  GN_Table[piece][start][start-7].nextdir = start-9;
                  GN_Table[piece][start][start-7].condition = 1;
                  GN_Table[piece][start][start-9].condition = 1;
                  continue;
               }
               if (PS_GetX(start)>1){
                  GN_Table[piece][start][start-8].nextdir = start-9;
                  GN_Table[piece][start][start-16].nextdir = start-9;
                  GN_Table[piece][start][start-9].condition = 1;
                  continue;
               }
               if (PS_GetX(start)<8){
                  GN_Table[piece][start][start-8].nextdir = start-7;
                  GN_Table[piece][start][start-16].nextdir = start-7;
                  GN_Table[piece][start][start-7].condition = 1;
                  continue;
               }
             }
             if (PS_GetY(start)>1){
               GN_Table[piece][start][start-8].condition = 2;
               GN_Table[piece][start][start].nextpos = start-8;
               GN_Table[piece][start][start-8].nextdir = -1;
               if ((PS_GetX(start)>1)&&(PS_GetX(start)<8)){
                  GN_Table[piece][start][start-8].nextdir = start-7;
                  GN_Table[piece][start][start-7].nextdir = start-9;
                  GN_Table[piece][start][start-7].condition = 1;
                  GN_Table[piece][start][start-9].condition = 1;
                  continue;
               }
               if (PS_GetX(start)>1){
                  GN_Table[piece][start][start-8].nextdir = start-9;
                  GN_Table[piece][start][start-9].condition = 1;
                  continue;
               }
               if (PS_GetX(start)<8){
                  GN_Table[piece][start][start-8].nextdir = start-7;
                  GN_Table[piece][start][start-7].condition = 1;
                  continue;
               }
             }
     }
     break;
     case KNIGHT: //*************** KNIGHT *********************
     for(start=0;start<64;start++){
             previous = start;
             if ((PS_GetY(start)>2)&&(PS_GetX(start)!=1)) {
               if (previous!=start) GN_Table[piece][start][previous].nextdir = start-17;
               else GN_Table[piece][start][previous].nextpos = start-17;
               previous = start-17;
             }
             if ((PS_GetY(start)>2)&&(PS_GetX(start)!=8)) {
               if (previous!=start) GN_Table[piece][start][previous].nextdir = start-15;
               else GN_Table[piece][start][previous].nextpos = start-15;
               previous = start-15;
             }
             if ((PS_GetY(start)<7)&&(PS_GetX(start)!=1)) {
               if (previous!=start) GN_Table[piece][start][previous].nextdir = start+15;
               else GN_Table[piece][start][previous].nextpos = start+15;
               previous = start+15;
             }
             if ((PS_GetY(start)<7)&&(PS_GetX(start)!=8)) {
               if (previous!=start) GN_Table[piece][start][previous].nextdir = start+17;
               else GN_Table[piece][start][previous].nextpos = start+17;
               previous = start+17;
             }
             if ((PS_GetY(start)!=1)&&(PS_GetX(start)>2)) {
               if (previous!=start) GN_Table[piece][start][previous].nextdir = start-10;
               else GN_Table[piece][start][previous].nextpos = start-10;
               previous = start-10;
             }
             if ((PS_GetY(start)!=8)&&(PS_GetX(start)>2)) {
               if (previous!=start) GN_Table[piece][start][previous].nextdir = start+6;
               else GN_Table[piece][start][previous].nextpos = start+6;
               previous = start+6;
             }
             if ((PS_GetY(start)!=1)&&(PS_GetX(start)<7)) {
               if (previous!=start) GN_Table[piece][start][previous].nextdir = start-6;
               else GN_Table[piece][start][previous].nextpos = start-6;
               previous = start-6;
             }
             if ((PS_GetY(start)!=8)&&(PS_GetX(start)<7)) {
               if (previous!=start) GN_Table[piece][start][previous].nextdir = start+10;
               else GN_Table[piece][start][previous].nextpos = start+10;
               previous = start+10;
             }
     }
     break;
     case BISHOP: //*************** BISHOP *********************
     for(start=0;start<64;start++){
             futur=NOMOVE;
             if ((PS_GetY(start)!=1)&&(PS_GetX(start)!=8)){
                for(previous=start-7;;previous-=7){
                    if ((PS_GetY(previous)==1)||(PS_GetX(previous)==8)) break;
                    GN_Table[piece][start][previous].nextpos = previous-7;
                    GN_Table[piece][start][previous].nextdir = futur;
                }
                GN_Table[piece][start][previous].nextpos = futur;
                GN_Table[piece][start][previous].nextdir = futur;
                futur=start-7;
             }
             if ((PS_GetY(start)!=1)&&(PS_GetX(start)!=1)){
                for(previous=start-9;;previous-=9){
                    if ((PS_GetY(previous)==1)||(PS_GetX(previous)==1)) break;
                    GN_Table[piece][start][previous].nextpos = previous-9;
                    GN_Table[piece][start][previous].nextdir = futur;
                }
                GN_Table[piece][start][previous].nextpos = futur;
                GN_Table[piece][start][previous].nextdir = futur;
                futur=start-9;
             }
             if ((PS_GetY(start)!=8)&&(PS_GetX(start)!=8)){
                for(previous=start+9;;previous+=9){
                    if ((PS_GetY(previous)==8)||(PS_GetX(previous)==8)) break;
                    GN_Table[piece][start][previous].nextpos = previous+9;
                    GN_Table[piece][start][previous].nextdir = futur;
                }
                GN_Table[piece][start][previous].nextpos = futur;
                GN_Table[piece][start][previous].nextdir = futur;
                futur=start+9;
             }
             if ((PS_GetY(start)!=8)&&(PS_GetX(start)!=1)){
                for(previous=start+7;;previous+=7){
                    if ((PS_GetY(previous)==8)||(PS_GetX(previous)==1)) break;
                    GN_Table[piece][start][previous].nextpos = previous+7;
                    GN_Table[piece][start][previous].nextdir = futur;
                }
                GN_Table[piece][start][previous].nextpos = futur;
                GN_Table[piece][start][previous].nextdir = futur;
                futur=start+7;
             }
             GN_Table[piece][start][start].nextpos = futur;
     }
     break;
     case ROOK: //*************** ROOK *********************
     for(start=0;start<64;start++){
             futur=NOMOVE;
             if (PS_GetX(start)!=8){
                for(previous=start+1;;previous+=1){
                    if (PS_GetX(previous)==8) break;
                    GN_Table[piece][start][previous].nextpos = previous+1;
                    GN_Table[piece][start][previous].nextdir = futur;
                }
                GN_Table[piece][start][previous].nextpos = futur;
                GN_Table[piece][start][previous].nextdir = futur;
                futur=start+1;
             }
             if (PS_GetX(start)!=1){
                for(previous=start-1;;previous-=1){
                    if (PS_GetX(previous)==1) break;
                    GN_Table[piece][start][previous].nextpos = previous-1;
                    GN_Table[piece][start][previous].nextdir = futur;
                }
                GN_Table[piece][start][previous].nextpos = futur;
                GN_Table[piece][start][previous].nextdir = futur;
                futur=start-1;
             }
             if (PS_GetY(start)!=8){
                for(previous=start+8;;previous+=8){
                    if (PS_GetY(previous)==8) break;
                    GN_Table[piece][start][previous].nextpos = previous+8;
                    GN_Table[piece][start][previous].nextdir = futur;
                }
                GN_Table[piece][start][previous].nextpos = futur;
                GN_Table[piece][start][previous].nextdir = futur;
                futur=start+8;
             }
             if (PS_GetY(start)!=1){
                for(previous=start-8;;previous-=8){
                    if (PS_GetY(previous)==1) break;
                    GN_Table[piece][start][previous].nextpos = previous-8;
                    GN_Table[piece][start][previous].nextdir = futur;
                }
                GN_Table[piece][start][previous].nextpos = futur;
                GN_Table[piece][start][previous].nextdir = futur;
                futur=start-8;
             }
             GN_Table[piece][start][start].nextpos = futur;
     }
     break;
     case QUEEN: //*************** QUEEN *********************
     for(start=0;start<64;start++){
             futur=NOMOVE;
             if ((PS_GetY(start)!=1)&&(PS_GetX(start)!=8)){
                for(previous=start-7;;previous-=7){
                    if ((PS_GetY(previous)==1)||(PS_GetX(previous)==8)) break;
                    GN_Table[piece][start][previous].nextpos = previous-7;
                    GN_Table[piece][start][previous].nextdir = futur;
                }
                GN_Table[piece][start][previous].nextpos = futur;
                GN_Table[piece][start][previous].nextdir = futur;
                futur=start-7;
             }
             if ((PS_GetY(start)!=1)&&(PS_GetX(start)!=1)){
                for(previous=start-9;;previous-=9){
                    if ((PS_GetY(previous)==1)||(PS_GetX(previous)==1)) break;
                    GN_Table[piece][start][previous].nextpos = previous-9;
                    GN_Table[piece][start][previous].nextdir = futur;
                }
                GN_Table[piece][start][previous].nextpos = futur;
                GN_Table[piece][start][previous].nextdir = futur;
                futur=start-9;
             }
             if ((PS_GetY(start)!=8)&&(PS_GetX(start)!=8)){
                for(previous=start+9;;previous+=9){
                    if ((PS_GetY(previous)==8)||(PS_GetX(previous)==8)) break;
                    GN_Table[piece][start][previous].nextpos = previous+9;
                    GN_Table[piece][start][previous].nextdir = futur;
                }
                GN_Table[piece][start][previous].nextpos = futur;
                GN_Table[piece][start][previous].nextdir = futur;
                futur=start+9;
             }
             if ((PS_GetY(start)!=8)&&(PS_GetX(start)!=1)){
                for(previous=start+7;;previous+=7){
                    if ((PS_GetY(previous)==8)||(PS_GetX(previous)==1)) break;
                    GN_Table[piece][start][previous].nextpos = previous+7;
                    GN_Table[piece][start][previous].nextdir = futur;
                }
                GN_Table[piece][start][previous].nextpos = futur;
                GN_Table[piece][start][previous].nextdir = futur;
                futur=start+7;
             }
             if (PS_GetX(start)!=8){
                for(previous=start+1;;previous+=1){
                    if (PS_GetX(previous)==8) break;
                    GN_Table[piece][start][previous].nextpos = previous+1;
                    GN_Table[piece][start][previous].nextdir = futur;
                }
                GN_Table[piece][start][previous].nextpos = futur;
                GN_Table[piece][start][previous].nextdir = futur;
                futur=start+1;
             }
             if (PS_GetX(start)!=1){
                for(previous=start-1;;previous-=1){
                    if (PS_GetX(previous)==1) break;
                    GN_Table[piece][start][previous].nextpos = previous-1;
                    GN_Table[piece][start][previous].nextdir = futur;
                }
                GN_Table[piece][start][previous].nextpos = futur;
                GN_Table[piece][start][previous].nextdir = futur;
                futur=start-1;
             }
             if (PS_GetY(start)!=8){
                for(previous=start+8;;previous+=8){
                    if (PS_GetY(previous)==8) break;
                    GN_Table[piece][start][previous].nextpos = previous+8;
                    GN_Table[piece][start][previous].nextdir = futur;
                }
                GN_Table[piece][start][previous].nextpos = futur;
                GN_Table[piece][start][previous].nextdir = futur;
                futur=start+8;
             }
             if (PS_GetY(start)!=1){
                for(previous=start-8;;previous-=8){
                    if (PS_GetY(previous)==1) break;
                    GN_Table[piece][start][previous].nextpos = previous-8;
                    GN_Table[piece][start][previous].nextdir = futur;
                }
                GN_Table[piece][start][previous].nextpos = futur;
                GN_Table[piece][start][previous].nextdir = futur;
                futur=start-8;
             }
             GN_Table[piece][start][start].nextpos = futur;
     }
     break;
     case KING: //*************** KING *********************
     for(start=0;start<64;start++){
             futur=NOMOVE;
             if ((PS_GetY(start)!=1)&&(PS_GetX(start)!=8)){
                GN_Table[piece][start][start-7].nextpos = futur;
                GN_Table[piece][start][start-7].nextdir = futur;
                futur=start-7;
             }
             if ((PS_GetY(start)!=1)&&(PS_GetX(start)!=1)){
                GN_Table[piece][start][start-9].nextpos = futur;
                GN_Table[piece][start][start-9].nextdir = futur;
                futur=start-9;
             }
             if ((PS_GetY(start)!=8)&&(PS_GetX(start)!=8)){
                GN_Table[piece][start][start+9].nextpos = futur;
                GN_Table[piece][start][start+9].nextdir = futur;
                futur=start+9;
             }
             if ((PS_GetY(start)!=8)&&(PS_GetX(start)!=1)){
                GN_Table[piece][start][start+7].nextpos = futur;
                GN_Table[piece][start][start+7].nextdir = futur;
                futur=start+7;
             }
             if (PS_GetX(start)!=8){
                GN_Table[piece][start][start+1].nextpos = futur;
                GN_Table[piece][start][start+1].nextdir = futur;
                futur=start+1;
             }
             if (PS_GetX(start)!=1){
                GN_Table[piece][start][start-1].nextpos = futur;
                GN_Table[piece][start][start-1].nextdir = futur;
                futur=start-1;
             }
             if (PS_GetY(start)!=8){
                GN_Table[piece][start][start+8].nextpos = futur;
                GN_Table[piece][start][start+8].nextdir = futur;
                futur=start+8;
             }
             if (PS_GetY(start)!=1){
                GN_Table[piece][start][start-8].nextpos = futur;
                GN_Table[piece][start][start-8].nextdir = futur;
                futur=start-8;
             }
             GN_Table[piece][start][start].nextpos = futur;
     }
     break;
     }
  }
}

int GN_Generate(board_t *board,bool color,move_t *result)
{
  bitboard_t bb;
  char piece;
  char nextpos;
  int  nbresult=0;
  char p;
  
  for(p=5;p>=0;p--)
    {
      bb = board->data[color][p];
      for(char start=0;start<64;start++)
	{
	  if ((color==BLACK)&&(p==PAWN)) piece = 6;
	  else piece=p;
	  if (FirstBit(bb)){
	    nextpos = GN_Table[piece][start][start].nextpos;
	    for(;;)
	      if (nextpos==99) break;
	      else if (BB_GetValue(board->color[1-color],nextpos)){
		if (GN_Table[piece][start][nextpos].condition != 2){
		  result[nbresult].start = start;
		  result[nbresult].stop = nextpos;
		  nbresult++;
		}
		nextpos = GN_Table[piece][start][nextpos].nextdir;
	      } else if (BB_GetValue(board->color[color],nextpos)){
		nextpos = GN_Table[piece][start][nextpos].nextdir;
	      } else if (GN_Table[piece][start][nextpos].condition != 1){
		result[nbresult].start = start;
		result[nbresult].stop = nextpos;
		if (GN_Table[piece][start][nextpos].nextpos==99)
		  nextpos = GN_Table[piece][start][nextpos].nextdir;
		else nextpos = GN_Table[piece][start][nextpos].nextpos;
		nbresult++;
	      } else if (GN_Table[piece][start][nextpos].condition == 1){
		nextpos = GN_Table[piece][start][nextpos].nextdir;
	      } else break;
	  }
	  bb = bb >> 1;
	}
    }
  if ((color == WHITE)&&(BB_GetValue(board->data[WHITE][KING],4)==true)){
    if ((BB_GetValue(board->color[WHITE],5)==false)&&(BB_GetValue(board->color[BLACK],5)==false)&&(BB_GetValue(board->color[WHITE],6)==false)&&(BB_GetValue(board->color[BLACK],6)==false)){
      result[nbresult].start = WSROCK;
      result[nbresult].stop = WSROCK;
      nbresult++;
    }
    if ((BB_GetValue(board->color[WHITE],3)==false)&&(BB_GetValue(board->color[BLACK],3)==false)&&(BB_GetValue(board->color[WHITE],2)==false)&&(BB_GetValue(board->color[BLACK],2)==false)&&(BB_GetValue(board->color[WHITE],1)==false)&&(BB_GetValue(board->color[BLACK],1)==false)){
      result[nbresult].start = WBROCK;
      result[nbresult].stop = WBROCK;
      nbresult++;
    }
  }
  if ((color == BLACK)&&(BB_GetValue(board->data[BLACK][KING],60)==true)){
    if ((BB_GetValue(board->color[WHITE],61)==false)&&(BB_GetValue(board->color[BLACK],61)==false)&&(BB_GetValue(board->color[WHITE],62)==false)&&(BB_GetValue(board->color[BLACK],62)==false)){
      result[nbresult].start = BSROCK;
      result[nbresult].stop = BSROCK;
      nbresult++;
    }
    if ((BB_GetValue(board->color[WHITE],59)==false)&&(BB_GetValue(board->color[BLACK],59)==false)&&(BB_GetValue(board->color[WHITE],58)==false)&&(BB_GetValue(board->color[BLACK],58)==false)&&(BB_GetValue(board->color[WHITE],57)==false)&&(BB_GetValue(board->color[BLACK],57)==false)){
      result[nbresult].start = BBROCK;
      result[nbresult].stop = BBROCK;
      nbresult++;
    }
  }
  return nbresult;
}


slint_t GN_Complexity(board_t *board,bool color)
{
  bitboard_t bb;
  slint_t  complexity=0;
  char piece,nextpos;
  int p;
  char start;

  color = true;
  for(p=5;p>=0;p--)
    {
      bb = board->data[color][p];
      for(start=0;start<64;start++)
	{
	  if ((color==BLACK)&&(p==PAWN)) piece = 6;
	  else piece=p;
	  if (FirstBit(bb)){
	    nextpos = GN_Table[piece][start][start].nextpos;
	    for(;;)
	      if (nextpos==99) break;
	      else if (BB_GetValue(board->color[1-color],nextpos)){
		if (GN_Table[piece][start][nextpos].condition != 2){
		  complexity++;
		}
		if (GN_Table[piece][start][nextpos].nextpos==99)
		  nextpos = GN_Table[piece][start][nextpos].nextdir;
		else nextpos = GN_Table[piece][start][nextpos].nextpos;
	      } else if (BB_GetValue(board->color[color],nextpos)){
		nextpos = GN_Table[piece][start][nextpos].nextdir;
	      } else if (GN_Table[piece][start][nextpos].condition != 1){
		if (GN_Table[piece][start][nextpos].nextpos==99)
		  nextpos = GN_Table[piece][start][nextpos].nextdir;
		else nextpos = GN_Table[piece][start][nextpos].nextpos;
	      } else if (GN_Table[piece][start][nextpos].condition == 1){
		nextpos = GN_Table[piece][start][nextpos].nextdir;
	      } else break;
	  }
	  bb = bb >> 1;
	}
    }
  return complexity;
}

