/*
 *  CINAG - Chess Is Not A Game
 * 
 *  Copyright (c) 2001, 2002 PAYEMENT Arnaud
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <stdlib.h>
#include "gui.h"

void window_t::create(int w,int h,bool f){
    const SDL_VideoInfo* info = NULL;
    int flags;
    if (SDL_Init( SDL_INIT_VIDEO|SDL_INIT_NOPARACHUTE) < 0 ) {
	fprintf( stderr, "Video initialization failed: %s\n",SDL_GetError( ) );
	exit(0);
    }
    info = SDL_GetVideoInfo( );
    if( !info ) {
	fprintf( stderr, "Video query failed: %s\n",SDL_GetError( ) );
	exit(0);
    }
    width = w;
    height = h;
    bpp = info->vfmt->BitsPerPixel;
    SDL_GL_SetAttribute( SDL_GL_RED_SIZE, 5 );
    SDL_GL_SetAttribute( SDL_GL_GREEN_SIZE, 5 );
    SDL_GL_SetAttribute( SDL_GL_BLUE_SIZE, 5 );
    SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE, 16 );
    SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );
    if (f == true) {
	flags = SDL_OPENGL | SDL_FULLSCREEN;
    } else flags = SDL_OPENGL;
    if( (surface = SDL_SetVideoMode(width,height, bpp, flags )) == 0 ) {
	fprintf( stderr, "Video mode set failed: %s\n",SDL_GetError( ) );
	exit(0);
    }
}

void window_t::close(){
    SDL_FreeSurface(surface);
    SDL_Quit();
}

void window_t::setCaption(char *caption){
    SDL_WM_SetCaption(caption,"");
}
