/*
 *  CINAG - Chess Is Not A Game
 * 
 *  Copyright (c) 2001, 2002 PAYEMENT Arnaud
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef TRANSPOSITION_H
#define TRANSPOSITION_H

#include "data.h"
#include "hashcode.h"

enum hashtype_t
{ hash_exact, hash_alpha, hash_beta };

typedef struct
{
    hashcode_t code2;
    hashtype_t type;
    char depth;
    slint_t value;
}
transpo_t;

void TP_Init ();
void TP_AddResult (hashcode_t,transpo_t,bool);
transpo_t TP_FindResult (hashcode_t,bool);
void TP_Exit ();
void TP_Free ();

#endif
