/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.peer.FileDialogPeer;
import java.io.FilenameFilter;

public class FileDialog
extends Dialog {
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    int mode;
    String dir;
    String file;
    FilenameFilter filter;
    private static final String base = "filedlg";
    private static int nameCounter;
    private static final long serialVersionUID = 5035145889651310422L;

    public FileDialog(Frame frame) {
        this(frame, "", 0);
    }

    public FileDialog(Frame frame, String string) {
        this(frame, string, 0);
    }

    public FileDialog(Frame frame, String string, int n) {
        super(frame, string, true);
        this.name = base + nameCounter++;
        this.mode = n;
        this.setLayout(null);
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createFileDialog(this);
        }
        super.addNotify();
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        switch (n) {
            case 0: 
            case 1: {
                this.mode = n;
                return;
            }
        }
        throw new IllegalArgumentException("illegal file dialog mode");
    }

    public String getDirectory() {
        return this.dir;
    }

    public synchronized void setDirectory(String string) {
        this.dir = string;
        FileDialogPeer fileDialogPeer = (FileDialogPeer)this.peer;
        if (fileDialogPeer != null) {
            fileDialogPeer.setDirectory(string);
        }
    }

    public String getFile() {
        return this.file;
    }

    public synchronized void setFile(String string) {
        this.file = string;
        FileDialogPeer fileDialogPeer = (FileDialogPeer)this.peer;
        if (fileDialogPeer != null) {
            fileDialogPeer.setFile(string);
        }
    }

    public FilenameFilter getFilenameFilter() {
        return this.filter;
    }

    public synchronized void setFilenameFilter(FilenameFilter filenameFilter) {
        this.filter = filenameFilter;
        FileDialogPeer fileDialogPeer = (FileDialogPeer)this.peer;
        if (fileDialogPeer != null) {
            fileDialogPeer.setFilenameFilter(filenameFilter);
        }
    }

    protected String paramString() {
        String string = super.paramString();
        if (this.dir != null) {
            string = String.valueOf(string) + ",dir= " + this.dir;
        }
        return String.valueOf(string) + (this.mode == 0 ? ",load" : ",save");
    }

    boolean postsOldMouseEvents() {
        return false;
    }
}

