/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.PrintStream;

public class ThreadGroup {
    ThreadGroup parent;
    String name;
    int maxPriority;
    boolean destroyed;
    boolean daemon;
    boolean vmAllowSuspension;
    int nthreads;
    Thread[] threads;
    int ngroups;
    ThreadGroup[] groups;

    private ThreadGroup() {
        this.name = "system";
        this.maxPriority = 10;
    }

    public ThreadGroup(String string) {
        this(Thread.currentThread().getThreadGroup(), string);
    }

    public ThreadGroup(ThreadGroup threadGroup, String string) {
        if (threadGroup == null) {
            throw new NullPointerException();
        }
        threadGroup.checkAccess();
        this.name = string;
        this.maxPriority = threadGroup.maxPriority;
        this.daemon = threadGroup.daemon;
        this.vmAllowSuspension = threadGroup.vmAllowSuspension;
        this.parent = threadGroup;
        threadGroup.add(this);
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getParent() {
        return this.parent;
    }

    public final int getMaxPriority() {
        return this.maxPriority;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    public final void setDaemon(boolean bl) {
        System.getSecurityManager().checkAccess(this);
        this.daemon = bl;
    }

    public final void setMaxPriority(int n) {
        ThreadGroup[] threadGroupArray;
        int n2;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            System.getSecurityManager().checkAccess(this);
            if (n < 1) {
                this.maxPriority = 1;
            } else if (n < this.maxPriority) {
                this.maxPriority = n;
            }
            n2 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
            } else {
                threadGroupArray = null;
            }
        }
        int n3 = 0;
        while (n3 < n2) {
            threadGroupArray[n3].setMaxPriority(n);
            ++n3;
        }
    }

    public final boolean parentOf(ThreadGroup threadGroup) {
        while (threadGroup != null) {
            if (threadGroup == this) {
                return true;
            }
            threadGroup = threadGroup.parent;
        }
        return false;
    }

    public final void checkAccess() {
        System.getSecurityManager().checkAccess(this);
    }

    public synchronized int activeCount() {
        if (this.destroyed) {
            return 0;
        }
        ThreadGroup threadGroup = this.enumeratableThreadGroup();
        if (threadGroup == null) {
            return 0;
        }
        return threadGroup.activeCount0();
    }

    private int activeCount0() {
        ThreadGroup[] threadGroupArray;
        int n;
        int n2;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                int n3 = 0;
                Object var6_4 = null;
                return n3;
            }
            n2 = this.nthreads;
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
        }
        int n4 = 0;
        while (n4 < n) {
            n2 += threadGroupArray[n4].activeCount0();
            ++n4;
        }
        return n2;
    }

    public int enumerate(Thread[] threadArray) {
        return this.enumerate(threadArray, true);
    }

    public int enumerate(Thread[] threadArray, boolean bl) {
        ThreadGroup threadGroup = this.enumeratableThreadGroup();
        if (threadGroup == null || !bl && this != threadGroup) {
            return 0;
        }
        return threadGroup.enumerate(threadArray, 0, bl);
    }

    private int enumerate(Thread[] threadArray, int n, boolean bl) {
        int n2 = 0;
        ThreadGroup[] threadGroupArray = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                int n3 = 0;
                Object var8_9 = null;
                return n3;
            }
            int n4 = this.nthreads;
            if (n4 > threadArray.length - n) {
                n4 = threadArray.length - n;
            }
            if (n4 > 0) {
                System.arraycopy(this.threads, 0, threadArray, n, n4);
                n += n4;
            }
            if (bl) {
                n2 = this.ngroups;
                if (this.groups != null) {
                    threadGroupArray = new ThreadGroup[n2];
                    System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
                } else {
                    threadGroupArray = null;
                }
            }
        }
        if (bl) {
            int n5 = 0;
            while (n5 < n2) {
                n = threadGroupArray[n5].enumerate(threadArray, n, true);
                ++n5;
            }
        }
        return n;
    }

    public synchronized int activeGroupCount() {
        if (this.destroyed) {
            return 0;
        }
        ThreadGroup threadGroup = this.enumeratableThreadGroup();
        if (threadGroup == null) {
            return 0;
        }
        int n = 0;
        ThreadGroup threadGroup2 = threadGroup;
        while (threadGroup2 != this) {
            ++n;
            threadGroup2 = threadGroup2.parent;
        }
        return n + threadGroup.activeGroupCount0();
    }

    private int activeGroupCount0() {
        ThreadGroup[] threadGroupArray;
        int n;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                int n2 = 0;
                Object var5_5 = null;
                return n2;
            }
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
        }
        int n3 = n;
        int n4 = 0;
        while (n4 < n) {
            n3 += threadGroupArray[n4].activeGroupCount0();
            ++n4;
        }
        return n3;
    }

    public int enumerate(ThreadGroup[] threadGroupArray) {
        return this.enumerate(threadGroupArray, true);
    }

    public synchronized int enumerate(ThreadGroup[] threadGroupArray, boolean bl) {
        ThreadGroup threadGroup = this.enumeratableThreadGroup();
        if (threadGroup == null) {
            return 0;
        }
        int n = 0;
        n = this.enumerateChildren(threadGroup, threadGroupArray, bl);
        if (!bl && n > 0) {
            return n;
        }
        return threadGroup.enumerate(threadGroupArray, n, bl);
    }

    private int enumerateChildren(ThreadGroup threadGroup, ThreadGroup[] threadGroupArray, boolean bl) {
        if (this == threadGroup) {
            return 0;
        }
        ThreadGroup threadGroup2 = threadGroup.parent;
        int n = this.enumerateChildren(threadGroup2, threadGroupArray, bl);
        if (n < threadGroupArray.length && (n == 0 || bl)) {
            threadGroupArray[n++] = threadGroup;
        }
        return n;
    }

    private int enumerate(ThreadGroup[] threadGroupArray, int n, boolean bl) {
        int n2 = 0;
        ThreadGroup[] threadGroupArray2 = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                int n3 = 0;
                Object var8_9 = null;
                return n3;
            }
            int n4 = this.ngroups;
            if (n4 > threadGroupArray.length - n) {
                n4 = threadGroupArray.length - n;
            }
            if (n4 > 0) {
                System.arraycopy(this.groups, 0, threadGroupArray, n, n4);
                n += n4;
            }
            if (bl) {
                n2 = this.ngroups;
                if (this.groups != null) {
                    threadGroupArray2 = new ThreadGroup[n2];
                    System.arraycopy(this.groups, 0, threadGroupArray2, 0, n2);
                } else {
                    threadGroupArray2 = null;
                }
            }
        }
        if (bl) {
            int n5 = 0;
            while (n5 < n2) {
                n = threadGroupArray2[n5].enumerate(threadGroupArray, n, true);
                ++n5;
            }
        }
        return n;
    }

    public final void stop() {
        ThreadGroup[] threadGroupArray;
        int n;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            System.getSecurityManager().checkAccess(this);
            int n2 = 0;
            while (n2 < this.nthreads) {
                this.threads[n2].stop();
                ++n2;
            }
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
        }
        int n3 = 0;
        while (n3 < n) {
            threadGroupArray[n3].stop();
            ++n3;
        }
    }

    public final void suspend() {
        ThreadGroup[] threadGroupArray;
        int n;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            System.getSecurityManager().checkAccess(this);
            int n2 = 0;
            while (n2 < this.nthreads) {
                this.threads[n2].suspend();
                ++n2;
            }
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
        }
        int n3 = 0;
        while (n3 < n) {
            threadGroupArray[n3].suspend();
            ++n3;
        }
    }

    public final void resume() {
        ThreadGroup[] threadGroupArray;
        int n;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            System.getSecurityManager().checkAccess(this);
            int n2 = 0;
            while (n2 < this.nthreads) {
                this.threads[n2].resume();
                ++n2;
            }
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
        }
        int n3 = 0;
        while (n3 < n) {
            threadGroupArray[n3].resume();
            ++n3;
        }
    }

    public final void destroy() {
        ThreadGroup[] threadGroupArray;
        int n;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            System.getSecurityManager().checkAccess(this);
            if (this.destroyed || this.nthreads > 0) {
                throw new IllegalThreadStateException();
            }
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
            if (this.parent != null) {
                this.destroyed = true;
                this.ngroups = 0;
                this.groups = null;
                this.nthreads = 0;
                this.threads = null;
            }
        }
        int n2 = 0;
        while (n2 < n) {
            threadGroupArray[n2].destroy();
            ++n2;
        }
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    private final void add(ThreadGroup threadGroup) {
        ThreadGroup threadGroup2 = this;
        synchronized (threadGroup2) {
            if (this.destroyed) {
                throw new IllegalThreadStateException();
            }
            SecurityManager.enablePrivilege("UniversalThreadGroupAccess");
            if (this.groups == null) {
                this.groups = new ThreadGroup[4];
            } else if (this.ngroups == this.groups.length) {
                ThreadGroup[] threadGroupArray = new ThreadGroup[this.ngroups * 2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, this.ngroups);
                this.groups = threadGroupArray;
            }
            this.groups[this.ngroups] = threadGroup;
            ++this.ngroups;
            return;
        }
    }

    private void remove(ThreadGroup threadGroup) {
        ThreadGroup threadGroup2 = this;
        synchronized (threadGroup2) {
            if (this.destroyed) {
                Object var3_3 = null;
                return;
            }
            int n = 0;
            while (n < this.ngroups) {
                if (this.groups[n] == threadGroup) {
                    --this.ngroups;
                    System.arraycopy(this.groups, n + 1, this.groups, n, this.ngroups - n);
                    this.groups[this.ngroups] = null;
                    break;
                }
                ++n;
            }
            if (this.nthreads == 0) {
                this.notifyAll();
            }
            if (this.daemon && this.nthreads == 0 && this.ngroups == 0) {
                SecurityManager.enablePrivilege("UniversalThreadGroupAccess");
                this.destroy();
            }
            return;
        }
    }

    void add(Thread thread) {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                throw new IllegalThreadStateException();
            }
            if (this.threads == null) {
                this.threads = new Thread[4];
            } else if (this.nthreads == this.threads.length) {
                Thread[] threadArray = new Thread[this.nthreads * 2];
                System.arraycopy(this.threads, 0, threadArray, 0, this.nthreads);
                this.threads = threadArray;
            }
            this.threads[this.nthreads] = thread;
            ++this.nthreads;
            return;
        }
    }

    void remove(Thread thread) {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                Object var3_3 = null;
                return;
            }
            int n = 0;
            while (n < this.nthreads) {
                if (this.threads[n] == thread) {
                    System.arraycopy(this.threads, n + 1, this.threads, n, --this.nthreads - n);
                    this.threads[this.nthreads] = null;
                    break;
                }
                ++n;
            }
            if (this.nthreads == 0) {
                this.notifyAll();
            }
            if (this.daemon && this.nthreads == 0 && this.ngroups == 0) {
                this.destroy();
            }
            return;
        }
    }

    public void list() {
        this.list(System.out, 0);
    }

    void list(PrintStream printStream, int n) {
        ThreadGroup[] threadGroupArray;
        int n2;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            int n3 = 0;
            while (n3 < n) {
                printStream.print(" ");
                ++n3;
            }
            printStream.println(this);
            n += 4;
            int n4 = 0;
            while (n4 < this.nthreads) {
                int n5 = 0;
                while (n5 < n) {
                    printStream.print(" ");
                    ++n5;
                }
                printStream.println(this.threads[n4]);
                ++n4;
            }
            n2 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
            } else {
                threadGroupArray = null;
            }
        }
        int n6 = 0;
        while (n6 < n2) {
            threadGroupArray[n6].list(printStream, n);
            ++n6;
        }
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        if (this.parent != null) {
            this.parent.uncaughtException(thread, throwable);
            return;
        }
        if (!(throwable instanceof ThreadDeath)) {
            throwable.printStackTrace(System.err);
        }
    }

    public boolean allowThreadSuspension(boolean bl) {
        this.vmAllowSuspension = bl;
        return true;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[name=" + this.getName() + ",maxpri=" + this.maxPriority + "]";
    }

    private ThreadGroup enumeratableThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        if (threadGroup == this || threadGroup.parentOf(this)) {
            return this;
        }
        if (this.parentOf(threadGroup)) {
            return threadGroup;
        }
        return null;
    }
}

