/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.util.RDN;

public final class DN
implements Serializable {
    private Vector m_rdns = new Vector();
    public static int RFC;
    public static int OSF;
    private int m_dnType = RFC;
    static final long serialVersionUID = -8867457218975952548L;
    public static final char[] ESCAPED_CHAR;

    public DN() {
    }

    public DN(String string) {
        if (string == null) {
            return;
        }
        if (this.isRFC(string)) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 0;
            StringBuffer stringBuffer2 = new StringBuffer();
            boolean bl = false;
            while (n < stringBuffer.length()) {
                stringBuffer2.append(stringBuffer.charAt(n));
                if (stringBuffer.charAt(n) == '\\') {
                    char c = stringBuffer.charAt(n + 1);
                    int n2 = 0;
                    while (n2 < ESCAPED_CHAR.length) {
                        if (c == ESCAPED_CHAR[n2]) {
                            stringBuffer2.append(stringBuffer.charAt(++n));
                            break;
                        }
                        ++n2;
                    }
                } else if (stringBuffer.charAt(n) == '\"') {
                    bl = !bl;
                } else if (stringBuffer.charAt(n) == ',' && !bl) {
                    stringBuffer2.setLength(stringBuffer2.length() - 1);
                    if (!this.appendRDN(stringBuffer2)) {
                        return;
                    }
                    stringBuffer2 = new StringBuffer();
                }
                ++n;
            }
            if (bl) {
                this.m_rdns.removeAllElements();
                return;
            }
            if (!this.appendRDN(stringBuffer2)) {
                return;
            }
        } else {
            if (string.indexOf(47) != -1) {
                this.m_dnType = OSF;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                Vector<RDN> vector = new Vector<RDN>();
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (RDN.isRDN(string2)) {
                        vector.addElement(new RDN(string2));
                        continue;
                    }
                    return;
                }
                int n = vector.size() - 1;
                while (n >= 0) {
                    this.m_rdns.addElement(vector.elementAt(n));
                    --n;
                }
                return;
            }
            if (RDN.isRDN(string)) {
                this.m_rdns.addElement(new RDN(string));
            }
        }
    }

    public void addRDNToFront(RDN rDN) {
        this.m_rdns.insertElementAt(rDN, 0);
    }

    public void addRDNToBack(RDN rDN) {
        this.m_rdns.addElement(rDN);
    }

    public void addRDN(RDN rDN) {
        if (this.m_dnType == RFC) {
            this.addRDNToFront(rDN);
            return;
        }
        this.addRDNToBack(rDN);
    }

    public void setDNType(int n) {
        this.m_dnType = n;
    }

    public int getDNType() {
        return this.m_dnType;
    }

    public int countRDNs() {
        return this.m_rdns.size();
    }

    public Vector getRDNs() {
        return this.m_rdns;
    }

    public String[] explodeDN(boolean bl) {
        if (this.m_rdns.size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.m_rdns.size()];
        int n = 0;
        while (n < this.m_rdns.size()) {
            stringArray[n] = bl ? ((RDN)this.m_rdns.elementAt(n)).getValue() : ((RDN)this.m_rdns.elementAt(n)).toString();
            ++n;
        }
        return stringArray;
    }

    public boolean isRFC() {
        return this.m_dnType == RFC;
    }

    public String toRFCString() {
        String string = "";
        int n = 0;
        while (n < this.m_rdns.size()) {
            if (n != 0) {
                string = String.valueOf(string) + ",";
            }
            string = String.valueOf(string) + ((RDN)this.m_rdns.elementAt(n)).toString();
            ++n;
        }
        return string;
    }

    public String toOSFString() {
        String string = "";
        int n = 0;
        while (n < this.m_rdns.size()) {
            if (n != 0) {
                string = "/" + string;
            }
            RDN rDN = (RDN)this.m_rdns.elementAt(n);
            string = String.valueOf(rDN.toString()) + string;
            ++n;
        }
        return string;
    }

    public String toString() {
        if (this.m_dnType == RFC) {
            return this.toRFCString();
        }
        return this.toOSFString();
    }

    public static boolean isDN(String string) {
        if (string.equals("")) {
            return true;
        }
        DN dN = new DN(string);
        return dN.countRDNs() > 0;
    }

    public boolean equals(DN dN) {
        return dN.toRFCString().toUpperCase().equals(this.toRFCString().toUpperCase());
    }

    public DN getParent() {
        DN dN = new DN();
        int n = this.m_rdns.size() - 1;
        while (n > 0) {
            dN.addRDN((RDN)this.m_rdns.elementAt(n));
            --n;
        }
        return dN;
    }

    public boolean contains(DN dN) {
        return this.isDescendantOf(dN);
    }

    /*
     * Unable to fully structure code
     */
    public boolean isDescendantOf(DN var1_1) {
        var2_2 = var1_1.m_rdns;
        var3_3 = this.m_rdns;
        var4_4 = var2_2.size() - 1;
        var5_5 = var3_3.size() - 1;
        if (var5_5 >= var4_4 && !this.equals(var1_1)) ** GOTO lbl13
        return false;
lbl-1000:
        // 1 sources

        {
            var6_6 = (RDN)var2_2.elementAt(var4_4);
            var7_7 = (RDN)var3_3.elementAt(var5_5);
            if (!var7_7.equals(var6_6)) {
                return false;
            }
            --var4_4;
            --var5_5;
lbl13:
            // 2 sources

            ** while (var4_4 >= 0 && var5_5 >= 0)
        }
lbl14:
        // 1 sources

        return true;
    }

    private boolean isRFC(String string) {
        int n = string.indexOf(44);
        while (n > 0 && n < string.length() - 1) {
            if (string.charAt(n - 1) != '\\') {
                return true;
            }
            n = string.indexOf(44, n + 1);
        }
        return false;
    }

    private boolean appendRDN(StringBuffer stringBuffer) {
        String string = new String(stringBuffer);
        if (RDN.isRDN(string)) {
            this.m_rdns.addElement(new RDN(string));
            return true;
        }
        this.m_rdns.removeAllElements();
        return false;
    }

    static {
        OSF = 1;
        ESCAPED_CHAR = new char[]{',', '+', '\"', '\\', ';'};
    }
}

