/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.Serializable;
import java.net.InetAddressImpl;
import java.net.UnknownHostException;
import java.util.Hashtable;

public final class InetAddress
implements Serializable {
    String hostName;
    int address;
    int family;
    private static final long serialVersionUID = 3286316764910316507L;
    static Hashtable addressCache;
    static InetAddress unknownAddress;
    static InetAddress anyLocalAddress;
    static InetAddress localHost;
    static InetAddress[] unknown_array;
    static InetAddressImpl impl;
    private static InetAddress loopbackHost;

    InetAddress() {
        this.family = impl.getInetFamily();
    }

    public InetAddress(int n) {
        this.address = n;
    }

    InetAddress(String string, byte[] byArray) {
        this.hostName = new String(string);
        this.family = impl.getInetFamily();
        this.address = byArray[3] & 0xFF;
        this.address |= byArray[2] << 8 & 0xFF00;
        this.address |= byArray[1] << 16 & 0xFF0000;
        this.address |= byArray[0] << 24 & 0xFF000000;
    }

    public boolean isMulticastAddress() {
        return (this.address & 0xF0000000) == -536870912;
    }

    public String getHostName() {
        block9: {
            if (this.hostName != null) break block9;
            try {
                this.hostName = new String(impl.getHostByAddr(this.address));
                InetAddress[] inetAddressArray = (InetAddress[])addressCache.get(this.hostName);
                if (inetAddressArray != null) {
                    int n = 0;
                    while (n < inetAddressArray.length) {
                        if (this.hostName.equalsIgnoreCase(inetAddressArray[n].hostName) && this.address != inetAddressArray[n].address) {
                            this.hostName = this.getHostAddress();
                            break;
                        }
                        ++n;
                    }
                } else {
                    inetAddressArray = new InetAddress[]{this};
                    addressCache.put(this.hostName, inetAddressArray);
                }
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkConnect(this.hostName, -1);
                }
            }
            catch (SecurityException securityException) {
                this.hostName = this.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                this.hostName = this.getHostAddress();
            }
        }
        return this.hostName;
    }

    public byte[] getAddress() {
        byte[] byArray = new byte[]{(byte)(this.address >>> 24 & 0xFF), (byte)(this.address >>> 16 & 0xFF), (byte)(this.address >>> 8 & 0xFF), (byte)(this.address & 0xFF)};
        return byArray;
    }

    public String getHostAddress() {
        return String.valueOf(this.address >>> 24 & 0xFF) + "." + (this.address >>> 16 & 0xFF) + "." + (this.address >>> 8 & 0xFF) + "." + (this.address & 0xFF);
    }

    public int hashCode() {
        return this.address;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof InetAddress && ((InetAddress)object).address == this.address;
    }

    public String toString() {
        return String.valueOf(this.getHostName()) + "/" + this.getHostAddress();
    }

    public static InetAddress getByName(String string) throws UnknownHostException {
        if (string == null || string.length() == 0) {
            return loopbackHost;
        }
        if (!Character.isDigit(string.charAt(0))) {
            return InetAddress.getAllByName0(string)[0];
        }
        int n = 0;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        int n3 = 0;
        while (n3 < cArray.length) {
            char c = cArray[n3];
            if (c < '0' || c > '9') {
                return InetAddress.getAllByName0(string)[0];
            }
            int n4 = 0;
            while (c != '.') {
                if (c < '0' || c > '9') {
                    return InetAddress.getAllByName0(string)[0];
                }
                n4 = n4 * 10 + c - 48;
                if (++n3 >= cArray.length) break;
                c = cArray[n3];
            }
            if (n4 > 255) {
                return InetAddress.getAllByName0(string)[0];
            }
            n = (n << 8) + n4;
            ++n2;
            ++n3;
        }
        if (n2 != 4 || string.endsWith(".")) {
            return InetAddress.getAllByName0(string)[0];
        }
        InetAddress inetAddress = new InetAddress();
        inetAddress.address = n;
        inetAddress.hostName = null;
        return inetAddress;
    }

    public static InetAddress[] getAllByName(String string) throws UnknownHostException {
        if (string == null || string.length() == 0) {
            throw new UnknownHostException("empty string");
        }
        if (Character.isDigit(string.charAt(0))) {
            InetAddress[] inetAddressArray = new InetAddress[]{InetAddress.getByName(string)};
            return inetAddressArray;
        }
        return InetAddress.getAllByName0(string);
    }

    private static InetAddress[] getAllByName0(String string) throws UnknownHostException {
        InetAddress[] inetAddressArray = null;
        Object object = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(string, -1);
        }
        Hashtable hashtable = addressCache;
        synchronized (hashtable) {
            inetAddressArray = addressCache.get(string);
            if (inetAddressArray == null) {
                try {
                    byte[][] byArray = impl.lookupAllHostAddr(string);
                    InetAddress[] inetAddressArray2 = new InetAddress[byArray.length];
                    int n = 0;
                    while (n < byArray.length) {
                        byte[] byArray2 = byArray[n];
                        inetAddressArray2[n] = new InetAddress(string, byArray2);
                        ++n;
                    }
                    inetAddressArray = inetAddressArray2;
                }
                catch (UnknownHostException unknownHostException) {
                    inetAddressArray = unknown_array;
                }
                addressCache.put(string, inetAddressArray);
            }
        }
        if (inetAddressArray == unknown_array) {
            throw new UnknownHostException(string);
        }
        try {
            object = inetAddressArray.clone();
            if (object == null) {
                throw new CloneNotSupportedException();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return (InetAddress[])object;
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        if (localHost.equals(unknownAddress)) {
            throw new UnknownHostException();
        }
        if (InetAddress.localHost.address == -1) {
            SecurityManager.enablePrivilege("UniversalConnect");
            localHost = InetAddress.getAllByName(InetAddress.localHost.hostName)[0];
        }
        return localHost;
    }

    static {
        SecurityManager.enablePrivilege("UniversalLinkAccess");
        System.loadLibrary("net");
        addressCache = new Hashtable();
        SecurityManager.enablePrivilege("UniversalPropertyRead");
        String string = System.getProperty("impl.prefix", "");
        try {
            impl = null;
            impl = (InetAddressImpl)Class.forName("java.net." + string + "InetAddressImpl").newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class not found: java.net." + string + "InetAddressImpl:\ncheck impl.prefix property " + "in your properties file.");
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Could not instantiate: java.net." + string + "InetAddressImpl:\ncheck impl.prefix property " + "in your properties file.");
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Cannot access class: java.net." + string + "InetAddressImpl:\ncheck impl.prefix property " + "in your properties file.");
        }
        if (impl == null) {
            try {
                impl = (InetAddressImpl)Class.forName("java.net.InetAddressImpl").newInstance();
            }
            catch (Exception exception) {
                throw new Error("System property impl.prefix incorrect");
            }
        }
        unknownAddress = new InetAddress();
        anyLocalAddress = new InetAddress();
        impl.makeAnyLocalAddress(anyLocalAddress);
        byte[] byArray = new byte[]{127, 0, 0, 1};
        loopbackHost = new InetAddress("localhost", byArray);
        try {
            localHost = new InetAddress();
            InetAddress.localHost.hostName = impl.getLocalHostName();
            InetAddress.localHost.address = -1;
        }
        catch (Exception exception) {
            localHost = unknownAddress;
        }
        String string2 = new String("0.0.0.0");
        unknown_array = new InetAddress[1];
        InetAddress.unknown_array[0] = new InetAddress(string2, unknownAddress.getAddress());
        addressCache.put(string2, unknown_array);
    }
}

